/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.config;

import com.envision.apim.poseidon.exception.PoseidonException;
import com.envision.apim.poseidon.util.SecurityUtils;
import java.util.Collections;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;

public class PConfig {
    private static final List<Protocol> HTTP_1_0 = Collections.singletonList(Protocol.HTTP_1_0);
    private static final List<Protocol> HTTP_1_1 = Collections.singletonList(Protocol.HTTP_1_1);
    private long connectTimeout = 60000L;
    private long writeTimeout = 60000L;
    private long readTimeout = 60000L;
    private String appKey;
    private String appSecret;
    private boolean debug = false;
    private boolean isAutoRedirect = false;
    private boolean verifySSL = true;
    private List<Protocol> protocols;
    private Interceptor interceptor;
    private Integer maxRequests;
    private Integer okHttpMaxRequests = 64;
    private Request request;
    private ProxyConfig proxyConfig;

    private void PConfig() {
    }

    public static PConfig init() {
        return new PConfig();
    }

    public PConfig appKey(String appkey) {
        this.appKey = appkey;
        return this;
    }

    public PConfig appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public PConfig debug() {
        this.debug = true;
        return this;
    }

    public PConfig maxRequests(Integer maxRequests) {
        if (maxRequests < 1) {
            throw new PoseidonException("maxRequests is dont low 1");
        }
        if (maxRequests > 64) {
            this.okHttpMaxRequests = maxRequests;
        }
        this.maxRequests = maxRequests;
        return this;
    }

    public PConfig connectTimeout(long milliSeconds) {
        this.connectTimeout = milliSeconds;
        return this;
    }

    public PConfig request(Request request) {
        this.request = request;
        return this;
    }

    public PConfig interceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public PConfig http_1_0() {
        this.protocols = HTTP_1_0;
        return this;
    }

    public PConfig http_1_1() {
        this.protocols = HTTP_1_1;
        return this;
    }

    public PConfig writeTimeout(long milliSeconds) {
        this.writeTimeout = milliSeconds;
        return this;
    }

    public PConfig readTimeout(long milliSeconds) {
        this.readTimeout = milliSeconds;
        return this;
    }

    public Integer getOkHttpMaxRequests() {
        return this.okHttpMaxRequests;
    }

    public Integer getMaxRequests() {
        return this.maxRequests;
    }

    public Request getRequest() {
        return this.request;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public PConfig proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public boolean isVerifySSL() {
        return this.verifySSL;
    }

    public PConfig verifySSL(boolean SSL) {
        this.verifySSL = SSL;
        return this;
    }

    public boolean isAutoRedirect() {
        return this.isAutoRedirect;
    }

    public PConfig autoRedirect() {
        this.isAutoRedirect = true;
        return this;
    }

    public String getMapKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.appKey).append(this.appSecret).append(this.connectTimeout).append(this.writeTimeout).append(this.readTimeout).append(this.verifySSL).append(this.isAutoRedirect).append(this.maxRequests);
        if (this.proxyConfig != null) {
            sb.append(this.proxyConfig.toString());
        }
        if (this.request != null) {
            sb.append(this.request.toString());
        }
        try {
            return SecurityUtils.md5(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return sb.toString();
        }
    }

    public static class ProxyConfig {
        String ip;
        Integer port;
        String userName = "";
        String password = "";

        public ProxyConfig(String ip, Integer port) {
            this.ip = ip;
            this.port = port;
        }

        public ProxyConfig(String ip, Integer port, String userName, String password) {
            this.ip = ip;
            this.port = port;
            this.userName = userName;
            this.password = password;
        }

        public String getIp() {
            return this.ip;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return this.ip + this.port + this.userName + this.password;
        }
    }
}

