/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data.jackson;

import com.ejlchina.data.Array;
import com.ejlchina.data.DataConvertor;
import com.ejlchina.data.Mapper;
import com.ejlchina.data.jackson.JacksonArray;
import com.ejlchina.data.jackson.JacksonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonDataConvertor
implements DataConvertor {
    private ObjectMapper objectMapper;
    private final Map<Type, TypeReference<?>> cache = new HashMap();
    private boolean typeCached;

    public JacksonDataConvertor() {
        this(new ObjectMapper());
    }

    public JacksonDataConvertor(ObjectMapper objectMapper) {
        this(objectMapper, false);
    }

    public JacksonDataConvertor(ObjectMapper objectMapper, boolean typeCached) {
        this.objectMapper = objectMapper;
        this.typeCached = typeCached;
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        try {
            JsonNode json = this.objectMapper.readTree((Reader)new InputStreamReader(in, charset));
            if (json.isObject()) {
                return new JacksonMapper((ObjectNode)json);
            }
            if (json.isNull() || json.isMissingNode()) {
                return null;
            }
            throw new IllegalStateException("\u4e0d\u662f \u4e00\u4e2a json \u5bf9\u8c61\uff1a" + json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public Array toArray(InputStream in, Charset charset) {
        try {
            JsonNode json = this.objectMapper.readTree((Reader)new InputStreamReader(in, charset));
            if (json.isArray()) {
                return new JacksonArray((ArrayNode)json);
            }
            if (json.isNull() || json.isMissingNode()) {
                return null;
            }
            throw new IllegalStateException("\u4e0d\u662f \u4e00\u4e2a json \u6570\u7ec4\uff1a" + json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public byte[] serialize(Object object, Charset charset) {
        if (object instanceof JacksonMapper || object instanceof JacksonArray) {
            return object.toString().getBytes(charset);
        }
        try {
            return this.objectMapper.writeValueAsString(object).getBytes(charset);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Java Bean [" + object + "] Jackson \u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> TypeReference<T> toTypeRef(final Type type) {
        TypeReference typeRef;
        Map<Type, TypeReference<?>> map = this.cache;
        synchronized (map) {
            typeRef = this.cache.get(type);
            if (typeRef == null) {
                typeRef = new TypeReference<T>(){

                    public Type getType() {
                        return type;
                    }
                };
                if (this.typeCached) {
                    this.cache.put(type, typeRef);
                }
            }
        }
        return typeRef;
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        try {
            return (T)this.objectMapper.readValue((Reader)new InputStreamReader(in, charset), this.toTypeRef(type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        CollectionType javaType = this.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
        try {
            return (List)this.objectMapper.readValue((Reader)new InputStreamReader(in, charset), (JavaType)javaType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isTypeCached() {
        return this.typeCached;
    }

    public void setTypeCached(boolean typeCached) {
        this.typeCached = typeCached;
    }
}

