/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.ejlchina.data.ListMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class BaseListMap<V>
extends AbstractMap<String, V>
implements ListMap<V> {
    final transient List<Map.Entry<String, V>> entries;
    transient Set<Map.Entry<String, V>> entrySet;

    public BaseListMap(List<Map.Entry<String, V>> entries) {
        this.entries = entries;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public V put(String key, V value) {
        if (key != null) {
            this.entries.add(new AbstractMap.SimpleEntry<String, V>(key, value));
        }
        return null;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return this.get((String)key, false);
        }
        return null;
    }

    @Override
    public V get(String key, boolean ic) {
        if (key != null) {
            ListIterator<Map.Entry<String, V>> it = this.entries.listIterator(this.entries.size());
            while (it.hasPrevious()) {
                Map.Entry<String, V> entry = it.previous();
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean keyMatch(String key1, String key2, boolean ic) {
        return ic && key1.equalsIgnoreCase(key2) || !ic && key1.equals(key2);
    }

    @Override
    public List<V> list(String key, boolean ic) {
        ArrayList<V> list = new ArrayList<V>();
        if (key != null) {
            for (Map.Entry<String, V> entry : this.entries) {
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                list.add(entry.getValue());
            }
        }
        return list;
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(String key, V value) {
        return this.replace(key, value, false);
    }

    @Override
    public V replace(String key, V value, boolean ic) {
        if (key != null) {
            ListIterator<Map.Entry<String, V>> it = this.entries.listIterator(this.entries.size());
            while (it.hasPrevious()) {
                Map.Entry<String, V> entry = it.previous();
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                return entry.setValue(value);
            }
        }
        return null;
    }

    @Override
    public int replaceAll(String key, V value, boolean ic) {
        int count = 0;
        if (key != null) {
            for (Map.Entry<String, V> entry : this.entries) {
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                entry.setValue(value);
                ++count;
            }
        }
        return count;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry<String, V> entry : this.entries) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            return this.remove((String)key, false);
        }
        return null;
    }

    @Override
    public V remove(String key, boolean ic) {
        if (key != null) {
            ListIterator<Map.Entry<String, V>> it = this.entries.listIterator(this.entries.size());
            while (it.hasPrevious()) {
                Map.Entry<String, V> entry = it.previous();
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                it.remove();
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public List<V> removeAll(String key, boolean ic) {
        ArrayList<V> list = new ArrayList<V>();
        if (key != null) {
            Iterator<Map.Entry<String, V>> it = this.entries.iterator();
            while (it.hasNext()) {
                Map.Entry<String, V> entry = it.next();
                if (!this.keyMatch(key, entry.getKey(), ic)) continue;
                list.add(entry.getValue());
                it.remove();
            }
        }
        return list;
    }

    class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return BaseListMap.this.entries.iterator();
        }

        @Override
        public int size() {
            return BaseListMap.this.entries.size();
        }
    }
}

