/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.EnumLite;
import com.dyuproject.protostuff.Tag;
import java.lang.reflect.Field;
import java.util.HashMap;

public final class EnumMapping {
    public final HashMap<Integer, Integer> numberIdxMap;
    public final int[] numbers;
    public final HashMap<String, Integer> nameIdxMap;
    public final String[] names;

    public static <T extends Enum<T>> EnumMapping createFrom(Class<T> clazz, T[] values) {
        return EnumMapping.getFrom(clazz, values);
    }

    public static EnumMapping getOrCreateFrom(Class<?> clazz) {
        return EnumMapping.getFrom(clazz, null);
    }

    private static EnumMapping getFrom(Class<?> clazz, Enum<?>[] values) {
        int i;
        Class<?> enumClass = clazz;
        Enum<?>[] constants = values != null ? values : (Enum[])enumClass.getEnumConstants();
        Enum<?> instance = constants[0];
        Field field = null;
        EnumMapping mapping = null;
        if (values == null && EnumLite.class.isAssignableFrom(instance.getClass())) {
            try {
                field = enumClass.getDeclaredField("$MAPPING");
                mapping = (EnumMapping)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mapping != null) {
                return mapping;
            }
        }
        try {
            field = enumClass.getField(instance.name());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (!field.isAnnotationPresent(Tag.class)) {
            return null;
        }
        HashMap<Integer, Integer> numberIdxMap = new HashMap<Integer, Integer>();
        int[] numbers = new int[constants.length];
        HashMap<String, Integer> nameIdxMap = new HashMap<String, Integer>();
        String[] names = new String[constants.length];
        int idx = i = 0;
        while (true) {
            Integer tmp;
            Tag annotation = field.getAnnotation(Tag.class);
            int fieldNumber = annotation.value();
            String name = annotation.alias();
            if (name == null || name.isEmpty()) {
                name = instance.name();
            }
            if (numberIdxMap.containsKey(tmp = Integer.valueOf(fieldNumber))) {
                idx = (Integer)numberIdxMap.get(tmp);
            } else {
                numberIdxMap.put(fieldNumber, i);
            }
            tmp = nameIdxMap.put(name, idx);
            if (tmp != null) {
                throw new IllegalStateException(constants[tmp] + " and " + constants[i] + " cannot have the same alias/name.");
            }
            numbers[i] = fieldNumber;
            String string = names[i] = i == idx ? name : names[idx];
            if (constants.length == ++i) break;
            instance = constants[i];
            try {
                field = enumClass.getField(instance.name());
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            if (!field.isAnnotationPresent(Tag.class)) {
                throw new RuntimeException("Missing @Tag annotation: " + field);
            }
            idx = i;
        }
        return new EnumMapping(numberIdxMap, numbers, nameIdxMap, names);
    }

    EnumMapping(HashMap<Integer, Integer> numberIdxMap, int[] numbers, HashMap<String, Integer> nameIdxMap, String[] names) {
        this.numberIdxMap = numberIdxMap;
        this.numbers = numbers;
        this.nameIdxMap = nameIdxMap;
        this.names = names;
    }
}

