/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.iam.auth.IamCustomize;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.IamUserFormDTO;
import com.diboot.iam.entity.IamAccount;
import com.diboot.iam.entity.IamOrg;
import com.diboot.iam.entity.IamRole;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.entity.IamUserRole;
import com.diboot.iam.mapper.IamAccountMapper;
import com.diboot.iam.mapper.IamRoleMapper;
import com.diboot.iam.mapper.IamUserMapper;
import com.diboot.iam.mapper.IamUserRoleMapper;
import com.diboot.iam.service.IamOrgService;
import com.diboot.iam.service.IamRoleService;
import com.diboot.tenant.entity.IamTenant;
import com.diboot.tenant.entity.IamTenantResource;
import com.diboot.tenant.mapper.IamTenantMapper;
import com.diboot.tenant.service.IamTenantResourceService;
import com.diboot.tenant.service.IamTenantService;
import com.diboot.tenant.vo.TenantAdminUserVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IamTenantServiceImpl
extends BaseServiceImpl<IamTenantMapper, IamTenant>
implements IamTenantService {
    private static final Logger log = LoggerFactory.getLogger(IamTenantServiceImpl.class);
    @Autowired
    private IamOrgService iamOrgService;
    @Autowired
    private IamUserMapper iamUserMapper;
    @Autowired
    private IamRoleService iamRoleService;
    @Autowired
    private IamRoleMapper iamRoleMapper;
    @Autowired
    private IamTenantResourceService iamTenantResourceService;
    @Autowired
    private IamUserRoleMapper iamUserRoleMapper;
    @Autowired
    private IamAccountMapper iamAccountMapper;
    @Autowired
    private IamCustomize iamCustomize;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createTenantAndInitData(IamTenant iamTenant) throws Exception {
        boolean success = this.createEntity((Object)iamTenant);
        if (!success) {
            log.error("\u521b\u5efa\u79df\u6237\u5931\u8d25\uff01");
            throw new BusinessException(Status.FAIL_EXCEPTION, "\u521b\u5efa\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff01", new Object[0]);
        }
        IamOrg iamOrg = this.buildRootOrgByTenant(iamTenant);
        success = this.iamOrgService.createEntity((Object)iamOrg);
        if (!success) {
            log.error("\u521b\u5efa\u79df\u6237\u9ed8\u8ba4IamOrg\u5931\u8d25\uff01");
            throw new BusinessException(Status.FAIL_EXCEPTION, "\u521b\u5efa\u79df\u6237\u9ed8\u8ba4IamOrg\u5931\u8d25\uff01", new Object[0]);
        }
        this.iamOrgService.updateEntity((Object)iamOrg.setRootOrgId((String)((Object)iamOrg.getId())));
        return true;
    }

    @Override
    public TenantAdminUserVO getTenantAdminUserVO(String tenantId) throws Exception {
        IamRole iamRole = this.iamRoleMapper.findByCode("TENANT_ADMIN", BaseConfig.getActiveFlagValue());
        if (iamRole == null) {
            this.iamRoleService.createEntity((Object)new IamRole().setCode("TENANT_ADMIN").setName("\u79df\u6237\u7ba1\u7406\u5458"));
        } else {
            String userId = this.iamUserRoleMapper.findUserIdByTenantIdAndRoleId(tenantId, (String)((Object)iamRole.getId()), BaseConfig.getActiveFlagValue());
            if (userId != null) {
                IamUser iamUser = this.iamUserMapper.selectById((Serializable)((Object)userId));
                TenantAdminUserVO tenantAdminUserVO = (TenantAdminUserVO)((Object)BeanUtils.convert((Object)iamUser, TenantAdminUserVO.class));
                IamAccount iamAccount = this.iamAccountMapper.findByExplicitTenant(tenantId, userId, IamUser.class.getSimpleName(), BaseConfig.getActiveFlagValue());
                tenantAdminUserVO.setUsername(iamAccount.getAuthAccount()).setAccountId((String)((Object)iamAccount.getId())).setAccountStatus(iamAccount.getStatus());
                return tenantAdminUserVO;
            }
        }
        return new TenantAdminUserVO();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean createOrUpdateTenantAdminUser(IamUserFormDTO iamUserFormDTO) throws Exception {
        IamAccount iamAccount = new IamAccount();
        if (V.notEmpty((String)iamUserFormDTO.getPassword())) {
            iamAccount.setAuthSecret(iamUserFormDTO.getPassword());
            this.iamCustomize.encryptPwd(iamAccount);
        }
        iamAccount.setTenantId(iamUserFormDTO.getTenantId()).setUserType(IamUser.class.getSimpleName()).setUserId((String)((Object)iamUserFormDTO.getId())).setAuthAccount(iamUserFormDTO.getUsername()).setStatus(iamUserFormDTO.getStatus()).setUpdateTime(LocalDateTime.now()).setId((Serializable)((Object)iamUserFormDTO.getAccountId()));
        if (V.isEmpty((String)((String)((Object)iamUserFormDTO.getId())))) {
            this.iamUserMapper.insert((Object)iamUserFormDTO);
            this.createIamRole(iamUserFormDTO);
            iamAccount.setUserId((String)((Object)iamUserFormDTO.getId()));
            this.iamAccountMapper.insert((Object)iamAccount);
        } else {
            this.iamUserMapper.updateTenantAdmin((IamUser)iamUserFormDTO, BaseConfig.getActiveFlagValue());
            this.iamAccountMapper.updateTenantAccount(iamAccount, BaseConfig.getActiveFlagValue());
        }
        return true;
    }

    @Override
    public List<String> getResourceIds(String tenantId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(IamTenantResource::getTenantId, (Object)tenantId);
        return this.iamTenantResourceService.getValuesOfField((Wrapper)queryWrapper, IamTenantResource::getResourceId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void createIamRole(IamUserFormDTO iamUserFormDTO) {
        IamRole iamRole = this.iamRoleMapper.findByCode("TENANT_ADMIN", BaseConfig.getActiveFlagValue());
        IamUserRole iamUserRole = new IamUserRole().setRoleId((String)((Object)iamRole.getId())).setUserId((String)((Object)iamUserFormDTO.getId())).setTenantId(iamUserFormDTO.getTenantId()).setUserType(IamUser.class.getSimpleName());
        this.iamUserRoleMapper.insert((Object)iamUserRole);
    }

    private IamOrg buildRootOrgByTenant(IamTenant tenant) {
        return new IamOrg().setCode(tenant.getCode()).setTenantId((String)((Object)tenant.getId())).setName(tenant.getName()).setParentId("0").setRootOrgId("0").setType(Cons.DICTCODE_ORG_TYPE.COMP.name());
    }
}

