/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.init;

import com.diboot.core.entity.Dictionary;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.SqlFileInitializer;
import com.diboot.core.vo.DictionaryVO;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.vo.IamResourceListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="diboot", name={"init-sql"}, havingValue="true")
public class TenantPluginInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(TenantPluginInitializer.class);

    public void run(ApplicationArguments args) throws Exception {
        String initDetectSql = "SELECT id FROM dbt_iam_tenant WHERE id='0'";
        if (!SqlFileInitializer.checkSqlExecutable((String)initDetectSql)) {
            SqlFileInitializer.initBootstrapSql(this.getClass(), (String)"tenant");
            this.insertInitData();
            log.info("diboot-tenant \u521d\u59cb\u5316SQL\u5b8c\u6210.");
        }
    }

    private void insertInitData() {
        IamResourceService resourcePermissionService;
        DictionaryService dictionaryService = (DictionaryService)ContextHolder.getBean(DictionaryService.class);
        if (dictionaryService != null && !dictionaryService.exists(Dictionary::getType, (Object)"TENANT_STATUS")) {
            String[] DICT_INIT_DATA;
            for (String dictJson : DICT_INIT_DATA = new String[]{"{\n  \"type\": \"TENANT_STATUS\",\n  \"itemName\": \"\u79df\u6237\u72b6\u6001\",\n  \"description\": \"\u79df\u6237\u72b6\u6001\u5b9a\u4e49\",\n  \"isEditable\": false,\n  \"children\": [\n    {\n      \"itemName\": \"\u6709\u6548\",\n      \"itemValue\": \"A\",\n      \"sortId\": 1\n    },\n    {\n      \"itemName\": \"\u65e0\u6548\",\n      \"itemValue\": \"I\",\n      \"sortId\": 2\n    }\n  ]\n}"}) {
                DictionaryVO dictVo = (DictionaryVO)JSON.toJavaObject((String)dictJson, DictionaryVO.class);
                dictionaryService.createDictAndChildren(dictVo);
            }
        }
        if ((resourcePermissionService = (IamResourceService)ContextHolder.getBean(IamResourceService.class)) != null && !resourcePermissionService.exists(IamResource::getResourceCode, (Object)"TenantMgt")) {
            String[] RESOURCE_PERMISSION_DATA = new String[]{"{\"displayType\":\"CATALOGUE\",\"displayName\":\"\u79df\u6237\u7ba1\u7406\",\"routePath\":\"tenant\",\"resourceCode\":\"TenantMgt\",\"meta\":\"{\\\"icon\\\":\\\"Element:Platform\\\"}\",\"sortId\":\"91\",\"children\":[{\"displayType\":\"MENU\",\"displayName\":\"\u79df\u6237\u4fe1\u606f\u7ba1\u7406\",\"routePath\":\"tenant\",\"resourceCode\":\"IamTenant\",\"permissionCode\":\"IamTenant:read\",\"meta\":\"{\\\"icon\\\":\\\"Element:User\\\",\\\"componentPath\\\":\\\"@/views/tenant/tenant-info/List.vue\\\"}\",\"sortId\":\"1\",\"children\":[{\"displayType\":\"PERMISSION\",\"displayName\":\"\u65b0\u5efa\",\"resourceCode\":\"create\",\"permissionCode\":\"IamTenant:write\",\"sortId\":\"40\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u66f4\u65b0\",\"resourceCode\":\"update\",\"permissionCode\":\"IamTenant:write,IamTenant:read\",\"sortId\":\"39\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u5220\u9664\",\"resourceCode\":\"delete\",\"permissionCode\":\"IamTenant:write\",\"sortId\":\"38\"},{\"displayType\":\"PERMISSION\",\"displayName\":\"\u8be6\u60c5\",\"resourceCode\":\"detail\",\"permissionCode\":\"IamTenant:read\",\"sortId\":\"37\"}]}]}"};
            try {
                for (String resourcePermissionJson : RESOURCE_PERMISSION_DATA) {
                    IamResourceListVO permissionListVO = (IamResourceListVO)JSON.toJavaObject((String)resourcePermissionJson, IamResourceListVO.class);
                    resourcePermissionService.deepCreateResourceAndChildren(permissionListVO);
                }
                RESOURCE_PERMISSION_DATA = null;
            }
            catch (BusinessException e) {
                log.error("\u521d\u59cb\u5316\u8d44\u6e90\u6743\u9650\u6570\u636e\u51fa\u9519: {}\uff0c\u8bf7\u624b\u52a8\u914d\u7f6e\u524d\u7aef\u8d44\u6e90\u521d\u59cb\u7684\u6743\u9650\u6570\u636e", (Object)e.getMessage());
            }
        }
    }
}

