/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.dto;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.PwdCredential;
import com.diboot.tenant.config.TenantProperties;
import com.diboot.tenant.entity.IamTenant;
import com.diboot.tenant.service.IamTenantService;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class TenantPwdCredential
extends PwdCredential {
    private static final long serialVersionUID = -5020652642432896556L;
    @NotNull(message="\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String tenantCode;

    public TenantPwdCredential() {
        this.setAuthType(Cons.DICTCODE_AUTH_TYPE.PWD.name());
    }

    public TenantPwdCredential(String username, String password, String tenantCode) {
        super(username, password);
        this.tenantCode = tenantCode;
        this.setAuthType(Cons.DICTCODE_AUTH_TYPE.PWD.name());
    }

    public String getTenantId() {
        if (V.notEmpty((String)super.getTenantId())) {
            return super.getTenantId();
        }
        if (V.equals((Object)this.tenantCode, (Object)((TenantProperties)Objects.requireNonNull(ContextHolder.getBean(TenantProperties.class))).getPlatformCode())) {
            this.setTenantId("0");
            return super.getTenantId();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(IamTenant::getCode, (Object)this.tenantCode);
        IamTenant tenant = (IamTenant)((Object)((IamTenantService)Objects.requireNonNull(ContextHolder.getBean(IamTenantService.class))).getSingleEntity((Wrapper)queryWrapper));
        if (tenant == null) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728", new Object[0]);
        }
        if (!Cons.DICTCODE_ACCOUNT_STATUS.A.name().equals(tenant.getStatus())) {
            throw new BusinessException("\u79df\u6237\u8d26\u6237\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u767b\u5f55", new Object[0]);
        }
        LocalDate startDate = tenant.getStartDate();
        LocalDate endDate = tenant.getEndDate();
        if (V.isEmpty((Object)startDate) || V.isEmpty((Object)endDate)) {
            throw new BusinessException("\u79df\u6237\u8d26\u6237\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u767b\u5f55", new Object[0]);
        }
        LocalDate now = LocalDate.now();
        if (now.isBefore(startDate)) {
            throw new BusinessException("\u79df\u6237\u8d26\u6237\u5c1a\u672a\u751f\u6548\uff0c\u65e0\u6cd5\u767b\u5f55", new Object[0]);
        }
        if (now.isAfter(endDate)) {
            throw new BusinessException("\u79df\u6237\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u767b\u5f55", new Object[0]);
        }
        this.setTenantId((String)((Object)tenant.getId()));
        return super.getTenantId();
    }

    public String getAuthAccount() {
        return this.getUsername();
    }

    public String getAuthSecret() {
        return this.getPassword();
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public TenantPwdCredential setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
        return this;
    }
}

