/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.starter;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.teaopenapi.models.Config;
import com.diboot.notification.channel.AliyunSmsChannel;
import com.diboot.notification.channel.SimpleEmailChannel;
import com.diboot.notification.channel.SystemMessageChannel;
import com.diboot.notification.config.NotificationProperties;
import com.diboot.notification.entity.BaseUserVariables;
import com.diboot.notification.service.MessageService;
import com.diboot.notification.service.impl.MessageServiceImpl;
import java.util.Arrays;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order(value=941)
@Configuration
@EnableConfigurationProperties(value={NotificationProperties.class})
@ComponentScan(basePackages={"com.diboot.notification"})
@MapperScan(basePackages={"com.diboot.notification.mapper"})
public class NotificationAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(NotificationAutoConfig.class);
    @Autowired
    private NotificationProperties notificationProperties;

    public NotificationAutoConfig() {
        log.info("\u521d\u59cb\u5316 notification \u7ec4\u4ef6\u81ea\u52a8\u914d\u7f6e");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Client.class})
    @EnableConfigurationProperties(value={NotificationProperties.class})
    public static class MessageServiceSMSConfig {
        @Autowired
        private NotificationProperties notificationProperties;

        @Bean
        @ConditionalOnMissingBean
        public MessageService messageService() {
            return new MessageServiceImpl(Arrays.asList(new SimpleEmailChannel(), new SystemMessageChannel(), new AliyunSmsChannel()), Arrays.asList(BaseUserVariables.class));
        }

        @Bean
        @ConditionalOnMissingBean
        public Client smsClient() throws Exception {
            Config config = new Config().setAccessKeyId(this.notificationProperties.getSms().getAccessKeyId()).setAccessKeySecret(this.notificationProperties.getSms().getAccessKeySecret()).setEndpoint(this.notificationProperties.getSms().getEndpoint());
            return new Client(config);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"com.aliyun.dysmsapi20170525.Client"})
    public static class MessageServiceConfig {
        @Bean
        @ConditionalOnMissingBean
        public MessageService messageService() {
            return new MessageServiceImpl(Arrays.asList(new SimpleEmailChannel(), new SystemMessageChannel()), Arrays.asList(BaseUserVariables.class));
        }
    }
}

