/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.notification.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.notification.channel.MessageChannel;
import com.diboot.notification.config.Cons;
import com.diboot.notification.entity.Message;
import com.diboot.notification.entity.MessageTemplate;
import com.diboot.notification.mapper.MessageMapper;
import com.diboot.notification.service.MessageService;
import com.diboot.notification.service.MessageTemplateService;
import com.diboot.notification.service.impl.MessageTemplateServiceImpl;
import com.diboot.notification.utils.TemplateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;

public class MessageServiceImpl
extends BaseServiceImpl<MessageMapper, Message>
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Lazy
    @Autowired
    private MessageTemplateService messageTemplateService;
    private Map<String, MessageChannel> typeToChannelMap = new HashMap<String, MessageChannel>();

    public MessageServiceImpl(List<MessageChannel> messageChannels, List<Class<?>> variableObjectClasses) {
        if (messageChannels != null) {
            for (MessageChannel channel : messageChannels) {
                this.typeToChannelMap.put(channel.type(), channel);
            }
        }
        MessageTemplateServiceImpl.extractVariablesFrom(variableObjectClasses);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean send(Message message) {
        return this.send(message, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean send(Message message, Object variableData) {
        LambdaQueryWrapper queryWrapper;
        MessageChannel channel = this.typeToChannelMap.get(message.getChannel());
        if (V.isEmpty((Object)channel)) {
            log.error("[\u83b7\u53d6\u53d1\u9001\u901a\u9053\u5931\u8d25]\uff0c\u5f53\u524d\u53d1\u9001\u901a\u9053\u4e3a\uff1a{}", (Object)message.getChannel());
            throw new InvalidUsageException("\u83b7\u53d6\u53d1\u9001\u901a\u9053\u5931\u8d25! " + message.getChannel(), new Object[0]);
        }
        String content = message.getContent();
        if (message.hasTemplate() && (queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(V.notEmpty((String)message.getTemplateId()), AbstractEntity::getId, (Object)message.getTemplateId())).eq(V.notEmpty((String)message.getTemplateCode()), MessageTemplate::getCode, (Object)message.getTemplateCode())).nonEmptyOfNormal()) {
            MessageTemplate messageTemplate = (MessageTemplate)((Object)this.messageTemplateService.getSingleEntity((Wrapper)queryWrapper));
            if (V.isEmpty((Object)((Object)messageTemplate))) {
                if (V.isEmpty((String)message.getTemplateCode())) {
                    log.error("[\u83b7\u53d6\u6a21\u7248\u5931\u8d25] \u6a21\u7248id\u4e3a\uff1a{}", (Object)message.getTemplateId());
                    throw new BusinessException(Status.FAIL_OPERATION, "\u83b7\u53d6\u6a21\u7248\u5931\u8d25!", new Object[0]);
                } else if (V.isEmpty((String)message.getTemplateId())) {
                    log.error("[\u83b7\u53d6\u6a21\u7248\u5931\u8d25] \u6a21\u7248code\u4e3a\uff1a{}", (Object)message.getTemplateCode());
                    throw new BusinessException(Status.FAIL_OPERATION, "\u83b7\u53d6\u6a21\u7248\u5931\u8d25!", new Object[0]);
                } else {
                    log.error("[\u83b7\u53d6\u6a21\u7248\u5931\u8d25] \u6a21\u7248id\u4e3a\uff1a{} \uff0c\u6a21\u7248code\u4e3a\uff1a{}", (Object)message.getTemplateId(), (Object)message.getTemplateCode());
                }
                throw new BusinessException(Status.FAIL_OPERATION, "\u83b7\u53d6\u6a21\u7248\u5931\u8d25!", new Object[0]);
            }
            message.setTemplateId((String)((Object)messageTemplate.getId()));
            content = messageTemplate.getContent();
        }
        if (!V.notEmpty((String)content)) throw new BusinessException("\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a null", new Object[0]);
        try {
            if (V.notEmpty((Object)variableData)) {
                content = TemplateUtils.parseTemplateContent(content, variableData);
                message.setContent(content);
                HashMap<String, Object> extDataMap = message.getExtDataMap();
                extDataMap = V.isEmpty(extDataMap) ? new HashMap<String, Object>() : extDataMap;
                extDataMap.put("variables", variableData);
                message.setExtDataMap(extDataMap);
            }
        }
        catch (Exception e) {
            log.error("[\u6d88\u606f\u89e3\u6790\u5931\u8d25]\uff0c\u6d88\u606f\u4f53\u4e3a\uff1a{}", (Object)message);
            throw new BusinessException(Status.FAIL_OPERATION, "\u6d88\u606f\u89e3\u6790\u5931\u8d25!", new Object[0]);
        }
        if (V.notEmpty((Object)message.getScheduleTime())) {
            message.setStatus("SCHEDULE");
        } else if (V.isEmpty((String)message.getStatus())) {
            message.setStatus(Cons.MESSAGE_STATUS.PENDING.name());
        }
        boolean success = this.createEntity((Object)message);
        if (V.notEmpty((Object)message.getScheduleTime())) {
            return true;
        }
        if (!success) {
            log.error("[\u6d88\u606f\u521b\u5efa\u5931\u8d25]\uff0c\u6d88\u606f\u4f53\u4e3a\uff1a{}", (Object)message);
            throw new BusinessException(Status.FAIL_OPERATION, "\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01", new Object[0]);
        }
        channel.send(message);
        return true;
    }
}

