/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.notification.init;

import com.diboot.core.entity.Dictionary;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.SqlFileInitializer;
import com.diboot.core.vo.DictionaryVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=941)
@Component
@ConditionalOnProperty(prefix="diboot", name={"init-sql"}, havingValue="true")
public class NotificationPluginInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(NotificationPluginInitializer.class);

    public void run(ApplicationArguments args) throws Exception {
        String initDetectSql = "SELECT id FROM dbt_message_template WHERE id='0'";
        if (!SqlFileInitializer.checkSqlExecutable((String)initDetectSql)) {
            SqlFileInitializer.initBootstrapSql(this.getClass(), (String)"notification");
            this.insertInitData();
            log.info("diboot-notification \u521d\u59cb\u5316SQL\u5b8c\u6210.");
        }
    }

    private void insertInitData() {
        DictionaryService dictionaryService = (DictionaryService)ContextHolder.getBean(DictionaryService.class);
        if (dictionaryService != null && !dictionaryService.exists(Dictionary::getType, (Object)"MESSAGE_CHANNEL")) {
            String[] DICT_INIT_DATA;
            for (String dictJson : DICT_INIT_DATA = new String[]{"{\"type\":\"MESSAGE_STATUS\", \"itemName\":\"\u6d88\u606f\u72b6\u6001\", \"description\":\"message\u6d88\u606f\u72b6\u6001\", \"children\":[{\"itemName\":\"\u53d1\u9001\u4e2d\", \"itemValue\":\"PENDING\", \"sortId\":1},{\"itemName\":\"\u53d1\u9001\u5931\u8d25\", \"itemValue\":\"FAILED\", \"sortId\":2},{\"itemName\":\"\u5df2\u9001\u8fbe\", \"itemValue\":\"DELIVERY\", \"sortId\":3},{\"itemName\":\"\u5df2\u8bfb\", \"itemValue\":\"READ\", \"sortId\":4}]}", "{\"type\":\"MESSAGE_CHANNEL\", \"itemName\":\"\u53d1\u9001\u901a\u9053\", \"description\":\"message\u53d1\u9001\u901a\u9053\", \"children\":[{\"itemName\":\"\u77ed\u4fe1\", \"itemValue\":\"SMS\", \"sortId\":1},{\"itemName\":\"\u7cfb\u7edf\u6d88\u606f\", \"itemValue\":\"SYS_MSG\", \"sortId\":2},{\"itemName\":\"\u7ad9\u5185\u4fe1\", \"itemValue\":\"WEBSOCKET\", \"sortId\":3},{\"itemName\":\"\u90ae\u4ef6\", \"itemValue\":\"EMAIL\", \"sortId\":4}]}"}) {
                DictionaryVO dictVo = (DictionaryVO)JSON.toJavaObject((String)dictJson, DictionaryVO.class);
                dictionaryService.createDictAndChildren(dictVo);
            }
            Object var2_2 = null;
        }
    }
}

