/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.notification.channel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.V;
import com.diboot.notification.channel.MessageChannel;
import com.diboot.notification.config.Cons;
import com.diboot.notification.entity.Message;
import com.diboot.notification.service.MessageService;
import java.util.Date;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;

public class SimpleEmailChannel
implements MessageChannel {
    private static final Logger log = LoggerFactory.getLogger(SimpleEmailChannel.class);

    @Override
    public String type() {
        return Cons.MESSAGE_CHANNEL.EMAIL.name();
    }

    @Override
    @Async
    public void send(Message message) {
        log.debug("[\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6]\uff1a\u90ae\u4ef6\u5185\u5bb9\uff1a{}", (Object)JSON.stringify((Object)((Object)message)));
        String result = "success";
        String status = Cons.MESSAGE_STATUS.DELIVERY.name();
        JavaMailSender javaMailSender = (JavaMailSender)ContextHolder.getBean(JavaMailSender.class);
        if (javaMailSender == null) {
            throw new InvalidUsageException("\u90ae\u4ef6\u65e0\u6cd5\u53d1\u9001\uff1a\u65e0JavaMailSender\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u53ca\u4f9d\u8d56\u73af\u5883\u3002", new Object[0]);
        }
        try {
            String[] fileUrlList;
            MimeMessage mimeMessage = javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setSubject(message.getTitle());
            messageHelper.setText(message.getContent(), true);
            messageHelper.setFrom(message.getSender());
            if (V.notEmpty((String[])message.getReceivers())) {
                messageHelper.setTo(message.getReceivers());
            } else {
                messageHelper.setTo(message.getReceiver());
            }
            messageHelper.setCc(message.getCcEmails());
            messageHelper.setBcc(message.getBccEmails());
            messageHelper.setSentDate(new Date());
            for (String url : fileUrlList = message.getAttachments()) {
                FileSystemResource fileSystemResource = new FileSystemResource(url);
                messageHelper.addAttachment(MimeUtility.encodeWord((String)fileSystemResource.getFilename(), (String)"utf-8", (String)"B"), (InputStreamSource)fileSystemResource);
            }
            javaMailSender.send(mimeMessage);
        }
        catch (Exception e) {
            log.error("[\u53d1\u9001\u90ae\u4ef6\u5931\u8d25]\uff1a\u4fe1\u606f\u4e3a\uff1a {} , \u5f02\u5e38", (Object)message, (Object)e);
            result = e.getMessage();
            status = Cons.MESSAGE_STATUS.FAILED.name();
        }
        ((MessageService)ContextHolder.getBean(MessageService.class)).updateEntity((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Message::getResult, (Object)result)).set(Message::getStatus, (Object)status)).eq(AbstractEntity::getId, (Object)message.getId()));
    }
}

