/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.vo;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.config.Cons;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pagination
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Pagination.class);
    private static final long serialVersionUID = -4083929594112114522L;
    private int pageIndex = 1;
    private int pageSize = BaseConfig.getPageSize();
    private long totalCount = 0L;
    public static final String ORDER_BY_ID_DESC = Cons.FieldName.id.name() + ":DESC";
    public static final String ORDER_BY_CREATE_TIME_DESC = Cons.FieldName.createTime.name() + ":DESC";
    private String orderBy;

    public Pagination() {
    }

    public Pagination(int pageIndex) {
        this.setPageIndex(pageIndex);
    }

    public void setPageSize(int pageSize) {
        if (pageSize > 1000) {
            log.warn("\u5206\u9875pageSize\u8fc7\u5927\uff0c\u5c06\u88ab\u8c03\u6574\u4e3a\u9ed8\u8ba4\u9650\u503c\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u662f\u5426\u5408\u7406\uff01pageSize=" + pageSize);
            pageSize = 1000;
        }
        this.pageSize = pageSize;
    }

    public int getTotalPage() {
        if (this.totalCount <= 0L) {
            return 0;
        }
        return (int)Math.ceil((float)this.totalCount / (float)this.pageSize);
    }

    public void clearOrder() {
        this.orderBy = null;
    }

    public <T> Page<T> toPage(Class<?> entityClass) {
        ArrayList<OrderItem> orderItemList = null;
        if (V.notEmpty(this.orderBy)) {
            orderItemList = new ArrayList<OrderItem>();
            String[] orderByFields = S.split(this.orderBy);
            PropInfo propInfo = BindingCacheManager.getPropInfoByClass(entityClass);
            for (String field : orderByFields) {
                V.securityCheck(field);
                if (field.contains(":")) {
                    String[] fieldAndOrder = S.split((String)field, (String)":");
                    String fieldName = fieldAndOrder[0];
                    String columnName = S.toSnakeCase(fieldName);
                    if (propInfo != null) {
                        if (propInfo.getFieldToColumnMap().containsKey(fieldName)) {
                            columnName = propInfo.getFieldToColumnMap().get(fieldName);
                        } else if (propInfo.getColumnToFieldMap().containsKey(fieldName)) {
                            columnName = fieldName;
                        }
                    }
                    if ("DESC".equalsIgnoreCase(fieldAndOrder[1])) {
                        orderItemList.add(OrderItem.desc((String)columnName));
                        continue;
                    }
                    orderItemList.add(OrderItem.asc((String)columnName));
                    continue;
                }
                orderItemList.add(OrderItem.asc((String)S.toSnakeCase(field)));
            }
        }
        Page page = new Page().setCurrent((long)this.getPageIndex()).setSize((long)this.getPageSize()).setTotal(this.getTotalCount() > 0L ? -1L : this.getTotalCount());
        if (orderItemList != null) {
            page.addOrder(orderItemList);
        }
        return page;
    }

    public static boolean isPaginationParam(String paramName) {
        return Cons.PaginationParam.isPaginationParam(paramName);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Pagination setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    public Pagination setTotalCount(long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public Pagination setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }
}

