/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.vo;

import com.diboot.core.plugin.JsonResultFilter;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Pagination;
import com.diboot.core.vo.PagingJsonResult;
import com.diboot.core.vo.Status;
import java.io.Serializable;

public class JsonResult<T>
implements Serializable {
    private static final long serialVersionUID = 1001L;
    private int code;
    private String msg;
    private T data;
    private static boolean jsonResultFilterChecked = false;
    private static JsonResultFilter jsonResultFilter;

    public JsonResult() {
    }

    public JsonResult(boolean ok) {
        this(ok ? Status.OK : Status.FAIL_OPERATION);
    }

    public JsonResult(T data) {
        this.code = Status.OK.code();
        this.msg = Status.OK.label();
        this.initMsg(null);
        this.data = data;
    }

    public JsonResult(T data, String additionalMsg) {
        this.code = Status.OK.code();
        this.msg = Status.OK.label();
        this.initMsg(additionalMsg);
        this.data = data;
    }

    public JsonResult(Status status) {
        this.code = status.code();
        this.msg = status.label();
        this.initMsg(null);
        this.data = null;
    }

    public JsonResult(Status status, String additionalMsg) {
        this.code = status.code();
        this.msg = status.label();
        this.initMsg(additionalMsg);
        this.data = null;
    }

    public JsonResult(Status status, T data) {
        this.code = status.code();
        this.msg = status.label();
        this.initMsg(null);
        this.data = data;
    }

    public JsonResult(Status status, T data, String additionalMsg) {
        this.code = status.code();
        this.msg = status.label();
        this.initMsg(additionalMsg);
        this.data = data;
    }

    public JsonResult(int code, String label, T data) {
        this.code = code;
        this.msg = label;
        this.data = data;
    }

    public JsonResult<T> status(Status status) {
        this.code = status.code();
        if (this.msg == null) {
            this.msg = status.label();
        }
        return this;
    }

    public JsonResult<T> data(T data) {
        this.data = data;
        return this;
    }

    public JsonResult<T> msg(String additionalMsg) {
        this.initMsg(additionalMsg);
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return JsonResult.filterJsonResultData(this.data);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public PagingJsonResult<T> bindPagination(Pagination pagination) {
        return new PagingJsonResult(this, pagination);
    }

    private void initMsg(String additionalMsg) {
        if (V.notEmpty(additionalMsg)) {
            this.msg = S.startsWith((CharSequence)additionalMsg, (CharSequence)this.msg) ? additionalMsg : this.msg + ": " + additionalMsg;
        }
    }

    public static <T> JsonResult<T> OK() {
        return new JsonResult<T>(Status.OK);
    }

    public static <T> JsonResult<T> OK(T data) {
        return new JsonResult<T>(Status.OK, data);
    }

    public static <T> JsonResult<T> WARN_PARTIAL_SUCCESS(String msg) {
        return new JsonResult<T>(Status.WARN_PARTIAL_SUCCESS).msg(msg);
    }

    public static <T> JsonResult<T> WARN_PERFORMANCE_ISSUE(String msg) {
        return new JsonResult<T>(Status.WARN_PERFORMANCE_ISSUE).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_INVALID_PARAM(String msg) {
        return new JsonResult<T>(Status.FAIL_INVALID_PARAM).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_INVALID_TOKEN(String msg) {
        return new JsonResult<T>(Status.FAIL_INVALID_TOKEN).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_NO_PERMISSION(String msg) {
        return new JsonResult<T>(Status.FAIL_NO_PERMISSION).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_NOT_FOUND(String msg) {
        return new JsonResult<T>(Status.FAIL_NOT_FOUND).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_VALIDATION(String msg) {
        return new JsonResult<T>(Status.FAIL_VALIDATION).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_OPERATION(String msg) {
        return new JsonResult<T>(Status.FAIL_OPERATION).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_EXCEPTION(String msg) {
        return new JsonResult<T>(Status.FAIL_EXCEPTION).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_REQUEST_TIMEOUT(String msg) {
        return new JsonResult<T>(Status.FAIL_REQUEST_TIMEOUT).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_SERVICE_UNAVAILABLE(String msg) {
        return new JsonResult<T>(Status.FAIL_SERVICE_UNAVAILABLE).msg(msg);
    }

    public static <T> JsonResult<T> FAIL_AUTHENTICATION(String msg) {
        return new JsonResult<T>(Status.FAIL_AUTHENTICATION).msg(msg);
    }

    private static <T> T filterJsonResultData(T data) {
        if (jsonResultFilterChecked && jsonResultFilter == null) {
            return data;
        }
        if (!jsonResultFilterChecked) {
            jsonResultFilter = ContextHolder.getBean(JsonResultFilter.class);
            jsonResultFilterChecked = true;
        }
        if (jsonResultFilter != null) {
            jsonResultFilter.filterData(data);
        }
        return data;
    }
}

