/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util.sql;

import com.diboot.core.util.S;
import com.diboot.core.util.sql.BaseTranslator;
import java.util.List;

public final class SqlServerTranslator
extends BaseTranslator {
    public SqlServerTranslator() {
    }

    public SqlServerTranslator(List<String> keywords) {
        this.ESCAPE_KEYWORDS.addAll(keywords);
    }

    @Override
    protected String translateColDefineSql(String colDefineSql) {
        colDefineSql = S.replaceEach((String)colDefineSql, (String[])new String[]{"tinyint(1)"}, (String[])new String[]{"tinyint"});
        return this.escapeKeyword(colDefineSql);
    }

    @Override
    protected String translateCreateIndexDDL(String mysqlDDL) {
        String createIndex = super.translateCreateIndexDDL(mysqlDDL);
        return S.replaceIgnoreCase((String)createIndex, (String)" index ", (String)" nonclustered index ");
    }

    @Override
    protected String buildColumnCommentSql(String table, String colName, String comment) {
        table = S.replace((String)table, (String)"`", (String)"");
        colName = S.replace((String)colName, (String)"`", (String)"");
        return "execute sp_addextendedproperty 'MS_Description', N'" + comment.trim() + "', 'SCHEMA', 'dbo', 'table', '" + table + "', 'column', '" + colName + "';";
    }

    @Override
    protected String buildTableCommentSql(String table, String comment) {
        table = S.replace((String)table, (String)"`", (String)"");
        return "execute sp_addextendedproperty 'MS_Description', N'" + comment.trim() + "','SCHEMA', 'dbo', 'table', '" + table + "', null, null;";
    }

    @Override
    protected String escapeKeyword(String input) {
        if (input.contains("`")) {
            String key = S.substringBetween((String)input, (String)"`", (String)"`");
            if (this.ESCAPE_KEYWORDS.contains(key)) {
                return S.replace((String)input, (String)("`" + key + "`"), (String)("[" + key + "]"));
            }
            return S.replace((String)input, (String)"`", (String)"");
        }
        return input;
    }
}

