/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util.sql;

import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.util.sql.BaseTranslator;
import java.util.List;

public class PostgresSqlTranslator
extends BaseTranslator {
    public PostgresSqlTranslator() {
    }

    public PostgresSqlTranslator(List<String> keywords) {
        this.ESCAPE_KEYWORDS.addAll(keywords);
    }

    @Override
    protected String translateColDefineSql(String colDefineSql) {
        if (S.containsIgnoreCase((CharSequence)colDefineSql, (CharSequence)"tinyint")) {
            colDefineSql = S.replaceEach((String)colDefineSql, (String[])new String[]{"tinyint(1)", "tinyint", "DEFAULT '1'", "DEFAULT 1", "default 1", "DEFAULT '0'", "default 0", "DEFAULT 0"}, (String[])new String[]{"BOOLEAN", "BOOLEAN", "DEFAULT TRUE", "DEFAULT TRUE", "DEFAULT TRUE", "DEFAULT FALSE", "DEFAULT FALSE", "DEFAULT FALSE"});
        } else if (S.containsIgnoreCase((CharSequence)colDefineSql, (CharSequence)"datetime")) {
            colDefineSql = S.replaceEach((String)colDefineSql, (String[])new String[]{"datetime"}, (String[])new String[]{"timestamp"});
        }
        return this.escapeKeyword(colDefineSql);
    }

    @Override
    protected String escapeKeyword(String input) {
        if (input.contains("`")) {
            String key = S.substringBetween((String)input, (String)"`", (String)"`");
            if (this.ESCAPE_KEYWORDS.contains(key)) {
                return S.replace((String)input, (String)("`" + key + "`"), (String)("\"" + key + "\""));
            }
            return S.replace((String)input, (String)"`", (String)"");
        }
        return input;
    }

    @Override
    protected Object translateValue(String colDefine, String value) {
        if (S.containsIgnoreCase((CharSequence)colDefine, (CharSequence)" BOOLEAN ")) {
            return V.isTrue(value);
        }
        return value;
    }
}

