/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util.init;

import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.init.BeanInitializer;
import java.util.Objects;
import java.util.function.Supplier;

public class BeanInitUtils {
    protected BeanInitUtils() {
    }

    public static <T> BeanInitializer<T> lazyInit(final Supplier<T> supplier) {
        return new LazyBeanInitializer<T>(){

            @Override
            protected T initialize() {
                return supplier.get();
            }
        };
    }

    public static <T> BeanInitializer<T> lazyInit(final Class<T> beanClass) {
        return new LazyBeanInitializer<T>(){

            @Override
            protected T initialize() {
                return Objects.requireNonNull(ContextHolder.getBean(beanClass), () -> "\u627e\u4e0d\u5230class\u5bf9\u5e94\u7684bean: " + beanClass.getName());
            }
        };
    }

    private static abstract class LazyBeanInitializer<T>
    implements BeanInitializer<T> {
        private static final Object NO_INIT = new Object();
        private volatile T object = NO_INIT;

        private LazyBeanInitializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            T result = this.object;
            if (result == NO_INIT) {
                LazyBeanInitializer lazyBeanInitializer = this;
                synchronized (lazyBeanInitializer) {
                    result = this.object;
                    if (result == NO_INIT) {
                        this.object = result = this.initialize();
                    }
                }
            }
            return result;
        }

        protected abstract T initialize() throws Exception;
    }
}

