/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.util.sql.DoNothingCallbackHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(SqlExecutor.class);
    private static JdbcTemplate jdbcTemplate;
    private static String CURRENT_SCHEMA;
    private static DoNothingCallbackHandler doNothingCallbackHandler;

    public static JdbcTemplate getJdbcTemplate() {
        if (jdbcTemplate == null) {
            jdbcTemplate = ContextHolder.getBean(JdbcTemplate.class);
        }
        return jdbcTemplate;
    }

    public static String getDatabase() {
        if (CURRENT_SCHEMA == null) {
            JdbcTemplate jdbcTemplate = SqlExecutor.getJdbcTemplate();
            DataSource dataSource = jdbcTemplate.getDataSource();
            if (dataSource == null) {
                throw new InvalidUsageException("\u5f53\u524d\u8fd0\u884c\u73af\u5883\u65e0\u83b7\u53d6\u6570\u636e\u6e90\u914d\u7f6e\uff01", new Object[0]);
            }
            try {
                Connection connection = dataSource.getConnection();
                if (connection.getCatalog() != null) {
                    CURRENT_SCHEMA = connection.getCatalog();
                } else if (connection.getSchema() != null) {
                    CURRENT_SCHEMA = connection.getSchema();
                }
                connection.close();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return null;
            }
        }
        return CURRENT_SCHEMA;
    }

    public static boolean validateQuery(String sqlStatement) {
        JdbcTemplate jdbcTemplate = SqlExecutor.getJdbcTemplate();
        if (jdbcTemplate != null) {
            try {
                log.debug("==> {}", (Object)sqlStatement);
                jdbcTemplate.query(sqlStatement, (RowCallbackHandler)doNothingCallbackHandler);
                return true;
            }
            catch (Exception e) {
                log.trace("\u6267\u884c\u9a8c\u8bc1SQL:{} \u5931\u8d25:{}", (Object)sqlStatement, (Object)e.getMessage());
                return false;
            }
        }
        throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6JdbcTemplate\u5b9e\u4f8b", new Object[0]);
    }

    public static List<Map<String, Object>> executeQuery(String sqlStatement, Object ... params) throws Exception {
        if (V.isEmpty(sqlStatement)) {
            return null;
        }
        JdbcTemplate jdbcTemplate = SqlExecutor.getJdbcTemplate();
        if (jdbcTemplate != null) {
            try {
                log.debug("==> {}", (Object)sqlStatement);
                if (V.isEmpty(params)) {
                    return jdbcTemplate.queryForList(sqlStatement);
                }
                return jdbcTemplate.queryForList(sqlStatement, params);
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u67e5\u8be2SQL:{} \u5931\u8d25:{}", (Object)sqlStatement, (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
        throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6JdbcTemplate\u5b9e\u4f8b", new Object[0]);
    }

    public static boolean executeUpdate(String sqlStatement, List params) throws Exception {
        if (V.isEmpty(sqlStatement)) {
            return false;
        }
        JdbcTemplate jdbcTemplate = SqlExecutor.getJdbcTemplate();
        if (jdbcTemplate != null) {
            try {
                log.debug("==> {}", (Object)sqlStatement);
                if (V.isEmpty(params)) {
                    jdbcTemplate.execute(sqlStatement);
                    return true;
                }
                return jdbcTemplate.update(sqlStatement, new Object[]{params}) >= 0;
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u66f4\u65b0SQL:{} \u5931\u8d25:{}", (Object)sqlStatement, (Object)e.getMessage());
                return false;
            }
        }
        throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6JdbcTemplate\u5b9e\u4f8b", new Object[0]);
    }

    public static boolean executeUpdate(Connection conn, String sql, List params) throws Exception {
        int i2;
        block12: {
            log.debug("==>  SQL: " + sql);
            if (V.notEmpty(params)) {
                log.debug("==>  Params: {}", (Object)JSON.stringify(params));
                if (params.size() > 2000) {
                    log.warn("\u66f4\u65b0\u53c2\u6570\u96c6\u5408\u6570\u91cf\u8fc7\u591a, size={}\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u662f\u5426\u5408\u7406\uff01", (Object)params.size());
                }
            }
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                if (V.notEmpty(params)) {
                    for (i2 = 0; i2 < params.size(); ++i2) {
                        stmt.setObject(i2 + 1, params.get(i2));
                    }
                }
                i2 = stmt.execute();
                if (stmt == null) break block12;
            }
            catch (Throwable i2) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            i2.addSuppressed(throwable);
                        }
                    }
                    throw i2;
                }
                catch (Exception e) {
                    String sqlInfo = S.substring((String)sql, (int)0, (int)50) + "...";
                    log.error("\u6267\u884csql\u67e5\u8be2\u5f02\u5e38: {}", (Object)sqlInfo, (Object)e);
                    throw e;
                }
            }
            stmt.close();
        }
        return i2 != 0;
    }

    static {
        CURRENT_SCHEMA = null;
        doNothingCallbackHandler = new DoNothingCallbackHandler();
    }
}

