/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.Encryptor;
import com.diboot.core.util.V;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PropertiesUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);
    private static Environment environment;

    public static void setEnvironment(Environment env) {
        if (environment == null) {
            environment = env;
        }
    }

    public static String get(String key, String defaultValue) {
        String value = PropertiesUtils.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String get(String key) {
        boolean isSensitiveConfig;
        if (environment == null) {
            try {
                environment = ContextHolder.getApplicationContext().getEnvironment();
                log.trace("\u901a\u8fc7Context\u83b7\u53d6Environment");
            }
            catch (Exception e) {
                log.warn("\u65e0\u6cd5\u83b7\u53d6Environment\uff0c\u53c2\u6570\u914d\u7f6e\u53ef\u80fd\u4e0d\u751f\u6548");
            }
        }
        if (environment == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e0b\u6587Environment\uff0c\u8bf7\u5728Spring\u521d\u59cb\u5316\u4e4b\u540e\u8c03\u7528!");
            return null;
        }
        String value = environment.getProperty(key);
        boolean bl = isSensitiveConfig = key.contains(".password") || key.contains(".secret");
        if (value != null && isSensitiveConfig) {
            value = Encryptor.decrypt(value, new String[0]);
        }
        return value;
    }

    public static Integer getInteger(String key) {
        return PropertiesUtils.getInteger(key, null);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        String value = PropertiesUtils.get(key);
        if (V.notEmpty(value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static Long getLong(String key) {
        return PropertiesUtils.getLong(key, null);
    }

    public static Long getLong(String key, Long defaultValue) {
        String value = PropertiesUtils.get(key);
        if (V.notEmpty(value)) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key) {
        return PropertiesUtils.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = PropertiesUtils.get(key);
        if (V.notEmpty(value)) {
            return V.isTrue(value);
        }
        return defaultValue;
    }
}

