/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);

    public static <T> T getIgnoreCase(Map<String, T> map, String key) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        if (S.isAllUpperCase((CharSequence)key)) {
            return map.get(key.toLowerCase());
        }
        return map.get(key.toUpperCase());
    }

    public static <T> T getIgnoreCase(Map<String, T> map, String key, T defaultVal) {
        if (map == null) {
            return defaultVal;
        }
        return MapUtils.getIgnoreCase(map, key);
    }

    public static <T> T buildEntity(Map<String, Object> dataMap, Class<T> entityClass) {
        if (V.isEmpty(dataMap)) {
            return null;
        }
        return JSON.parseObject(JSON.stringify(dataMap), entityClass);
    }

    public static <T> List<T> buildEntityList(List<Map<String, Object>> resultListMap, Class<T> entityClass) {
        if (V.isEmpty(resultListMap)) {
            return Collections.emptyList();
        }
        return JSON.parseArray(JSON.stringify(resultListMap), entityClass);
    }
}

