/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    private static final Logger log = LoggerFactory.getLogger(JSON.class);
    private static ObjectMapper objectMapper;

    private static ObjectMapper getObjectMapper() {
        if (objectMapper != null) {
            return objectMapper;
        }
        objectMapper = ContextHolder.getBean(ObjectMapper.class);
        if (objectMapper == null) {
            throw new InvalidUsageException("\u672a\u627e\u5230 ObjectMapper\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7c7b\uff01", new Object[0]);
        }
        return objectMapper;
    }

    public static String stringify(Object object) {
        return JSON.toJSONString(object);
    }

    public static String toJSONString(Object model) {
        try {
            String json = JSON.getObjectMapper().writeValueAsString(model);
            return json;
        }
        catch (Exception e) {
            log.error("Java\u8f6cJson\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new BusinessException("Java\u8f6cJson\u5f02\u5e38", new Object[]{e});
        }
    }

    public static <T> T toJavaObject(String jsonStr, Class<T> clazz) {
        try {
            Object model = JSON.getObjectMapper().readValue(jsonStr, clazz);
            return (T)model;
        }
        catch (Exception e) {
            log.error("Json: {} \u8f6cJava\u5f02\u5e38: {}", (Object)jsonStr, (Object)e.getMessage());
            throw new BusinessException("Json: {} \u8f6cJava\u5f02\u5e38\uff1a{}", jsonStr, e.getMessage());
        }
    }

    public static Map<String, Object> parseObject(String jsonStr) {
        try {
            JavaType javaType = JSON.getObjectMapper().getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, Object.class});
            return (Map)JSON.getObjectMapper().readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            log.error("Json: {} \u8f6cMap\u5f02\u5e38: {}", (Object)jsonStr, (Object)e.getMessage());
            throw new BusinessException("Json: {} \u8f6cMap\u5f02\u5e38: {}", jsonStr, e.getMessage());
        }
    }

    public static <T> T parseObject(String jsonStr, Class<T> clazz) {
        return JSON.toJavaObject(jsonStr, clazz);
    }

    public static <T> T parseObject(String jsonStr, TypeReference<T> typeReference) {
        try {
            Object model = JSON.getObjectMapper().readValue(jsonStr, typeReference);
            return (T)model;
        }
        catch (Exception e) {
            log.error("Json: {} \u8f6cJava\u5f02\u5e38: {}", (Object)jsonStr, (Object)e.getMessage());
            throw new BusinessException("Json: {} \u8f6cJava\u5f02\u5e38: {}", jsonStr, e.getMessage());
        }
    }

    public static <T> List<T> parseArray(String jsonStr, Class<T> clazz) {
        try {
            JavaType javaType = JSON.getObjectMapper().getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)JSON.getObjectMapper().readValue(jsonStr, javaType);
        }
        catch (Exception e) {
            log.error("Json: {} \u8f6cList\u5f02\u5e38: {}", (Object)jsonStr, (Object)e.getMessage());
            throw new BusinessException("Json: {} \u8f6cList\u5f02\u5e38", jsonStr, e.getMessage());
        }
    }

    public static <T> List<T> parseArray(String jsonStr, TypeReference<List<T>> typeReference) {
        try {
            return (List)JSON.getObjectMapper().readValue(jsonStr, typeReference);
        }
        catch (Exception e) {
            log.error("Json: {} \u8f6cList\u5f02\u5e38: {}", (Object)jsonStr, (Object)e.getMessage());
            throw new BusinessException("Json: {} \u8f6cList\u5f02\u5e38: {}", jsonStr, e.getMessage());
        }
    }

    public static <K, T> Map<K, T> toMap(String jsonStr) {
        return JSON.toJavaObject(jsonStr, Map.class);
    }

    public static <K, T> LinkedHashMap<K, T> toLinkedHashMap(String jsonStr) {
        if (V.isEmpty(jsonStr)) {
            return null;
        }
        return JSON.toJavaObject(jsonStr, LinkedHashMap.class);
    }
}

