/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.util.V;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    private static final String USER_AGENT_FLAG = "user-agent";
    private static final String[] HEADER_IP_KEYWORDS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "X-Real-IP"};

    public static Map<String, Object> buildParamsMap(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        if (!paramNames.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String[] values = request.getParameterValues(paramName);
                if (!V.notEmpty(values)) continue;
                if (values.length == 1) {
                    if (!V.notEmpty(values[0])) continue;
                    String paramValue = URLDecoder.decode(values[0], "UTF-8");
                    result.put(paramName, paramValue);
                    continue;
                }
                String[] valueArray = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueArray[i] = URLDecoder.decode(values[i], "UTF-8");
                }
                result.put(paramName, valueArray);
            }
        }
        catch (Exception e) {
            log.warn("\u6784\u5efa\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader(USER_AGENT_FLAG);
    }

    public static String getRequestIp(HttpServletRequest request) {
        for (String header : HEADER_IP_KEYWORDS) {
            String ipAddresses = request.getHeader(header);
            if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses) || !V.notEmpty(ipAddresses)) continue;
            return ipAddresses.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

