/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D
extends DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String FORMAT_DATE_y2M = "yyMM";
    public static final String FORMAT_DATE_y2Md = "yyMMdd";
    public static final String FORMAT_DATE_y4 = "yyyy";
    public static final String FORMAT_DATE_y4Md = "yyyyMMdd";
    public static final String FORMAT_TIMESTAMP = "yyMMddHHmmss";
    public static final String FORMAT_TIMESTAMP_Y4MDHM = "yyMMddHHmm";
    public static final String FORMAT_TIME_HHmm = "HH:mm";
    public static final String FORMAT_TIME_HHmmss = "HH:mm:ss";
    public static final String FORMAT_DATE_Y4MD = "yyyy-MM-dd";
    public static final String FORMAT_DATETIME_Y4MDHM = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_DATETIME_Y4MDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_SLASH_Y4MD = "yyyy/MM/dd";
    public static final String FORMAT_DATETIME_SLASH_Y4MDHM = "yyyy/MM/dd HH:mm";
    public static final String FORMAT_DATETIME_SLASH_Y4MDHMS = "yyyy/MM/dd HH:mm:ss";
    public static final String FORMAT_DATE_SLASH_MDY4 = "MM/dd/yyyy";
    public static final String FORMAT_DATETIME_SLASH_MDY4HM = "MM/dd/yyyy HH:mm";
    public static final String FORMAT_DATETIME_SLASH_MDY4HMS = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT_DATETIME_Y4MD_T_HMS = "yyyy-MM-ddTHH:mm:ss";
    public static final DateTimeFormatter FORMATTER_DATE_Y4MD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter FORMATTER_DATETIME_Y4MDHM = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter FORMATTER_DATETIME_Y4MDHMS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FORMATTER_TIME_HM = DateTimeFormatter.ofPattern("HH:mm");
    public static final String[] WEEK = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    public static final String[] WEEK_EN = new String[]{"Sun", "Mon", "Tue", "Wed", "Thur", "Fri", "Sat"};
    public static final String[] MONTH_CN = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
    public static final String[] MONTH_EN = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final long MS_1SECOND = 1000L;
    public static final long MS_1MINUTE = 60000L;
    public static final long MS_1HOUR = 3600000L;
    public static final long MS_1DAY = 86400000L;
    private static String[] FORMAT_SEARCH_LIST = new String[]{"\u5e74", "\u6708", "\u65e5", "/", "\\."};
    private static String[] FORMAT_REPLACEMENT_LIST = new String[]{"-", "-", "", "-", "-"};

    public static String now(String format) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(cal.getTime());
    }

    public static String toTimestamp(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_TIMESTAMP);
        return sdf.format(date.getTime());
    }

    @Deprecated
    public static String getMonth() {
        return D.now(FORMAT_DATE_y2M);
    }

    public static String today() {
        return D.now(FORMAT_DATE_y4Md);
    }

    public static Date convert2FormatDate(String datetime, String fmt) {
        if (StringUtils.isBlank((CharSequence)datetime)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        try {
            return format.parse(datetime);
        }
        catch (ParseException e) {
            log.warn("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
            return null;
        }
    }

    public static String convert2DateString(Date date) {
        return D.convert2FormatString(date, FORMAT_DATE_Y4MD);
    }

    public static String convert2DateTimeString(Date date) {
        return D.convert2FormatString(date, FORMAT_DATETIME_SLASH_Y4MDHMS);
    }

    public static String convert2FormatString(Date date, String fmt) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        return format.format(date);
    }

    public static String getDate(Date date, int ... daysOffset) {
        return D.getDate(date, FORMAT_DATE_Y4MD, daysOffset);
    }

    public static Date nextDay(Date date) {
        if (date == null) {
            return null;
        }
        return D.addDays((Date)date, (int)1);
    }

    public static String getDateTime(Date date, int ... daysOffset) {
        return D.getDate(date, FORMAT_DATETIME_Y4MDHM, daysOffset);
    }

    public static String getDate(Date date, String format, int ... daysOffset) {
        if (date == null) {
            date = new Date();
        }
        if (daysOffset != null && daysOffset.length > 0) {
            date = D.addDays((Date)date, (int)daysOffset[0]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static boolean isWorkingTime() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        return hour >= 8 && hour < 20;
    }

    public static String getAmPm() {
        Calendar c = Calendar.getInstance();
        int hours = c.get(11);
        if (hours <= 9) {
            return "\u65e9\u4e0a";
        }
        if (hours <= 12) {
            return "\u4e0a\u5348";
        }
        if (hours == 13) {
            return "\u4e2d\u5348";
        }
        if (hours <= 18) {
            return "\u4e0b\u5348";
        }
        return "\u665a\u4e0a";
    }

    public static String getYearMonth() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_y2M);
        return sdf.format(cal.getTime());
    }

    public static String getYearMonthDay() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_y2Md);
        return sdf.format(cal.getTime());
    }

    public static int getDay() {
        Calendar cal = Calendar.getInstance();
        return cal.get(5);
    }

    @Deprecated
    public static String getWeek(Date date) {
        return D.getCnWeek(date);
    }

    public static String getCnWeek() {
        int index = Calendar.getInstance().get(7) - 1;
        return WEEK[index];
    }

    public static String getCnWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return WEEK[cal.get(7) - 1];
    }

    public static String getEnWeek() {
        int index = Calendar.getInstance().get(7) - 1;
        return WEEK_EN[index];
    }

    public static String getEnWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return WEEK_EN[cal.get(7) - 1];
    }

    public static String getCnMonth() {
        return MONTH_CN[Calendar.getInstance().get(2)];
    }

    public static String getCnMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return MONTH_CN[cal.get(2)];
    }

    public static String getEnMonth() {
        return MONTH_EN[Calendar.getInstance().get(2)];
    }

    public static String getEnMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return MONTH_EN[cal.get(2)];
    }

    public static Date timeMillis2Date(Long timeMillis) {
        return new Date(timeMillis);
    }

    public static Date datetimeString2Date(String value) {
        return D.convert2DateTime(value, FORMAT_DATETIME_Y4MDHMS);
    }

    public static String formatDurationLabel(Long duration) {
        if (duration == null) {
            return "-";
        }
        long days = duration / 86400000L;
        if (days > 0L) {
            return days + "d";
        }
        long hours = duration / 3600000L;
        if (hours > 0L) {
            return hours + "h";
        }
        long minutes = duration / 60000L;
        if (minutes > 0L) {
            return minutes + "m";
        }
        long seconds = duration / 1000L;
        if (seconds > 0L) {
            return seconds + "s";
        }
        return "<1s";
    }

    public static Date convert2Date(String date) {
        if (date.contains("/")) {
            return D.convert2FormatDate(date, FORMAT_DATE_SLASH_Y4MD);
        }
        return D.convert2FormatDate(date, FORMAT_DATE_Y4MD);
    }

    public static List<String> rangeDateList(Date startTime, Date endTime) throws ParseException {
        if (startTime == null || endTime == null || startTime.after(endTime)) {
            return Collections.emptyList();
        }
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_DATE_Y4MD);
        String dBegin = format.format(startTime);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(format.parse(dBegin));
        int days = (int)((endTime.getTime() - startTime.getTime()) / 86400000L);
        ArrayList<String> rangeDateList = new ArrayList<String>(days);
        for (int i = 0; i < days; ++i) {
            rangeDateList.add(format.format(calBegin.getTime()));
            calBegin.add(5, 1);
        }
        return rangeDateList;
    }

    public static Date convert2DateTime(String dateTime, String ... dateFormat) {
        String f = FORMAT_DATETIME_Y4MDHM;
        if (dateFormat != null && dateFormat.length > 0) {
            f = dateFormat[0];
        }
        return D.convert2FormatDate(dateTime, f);
    }

    public static Date fuzzyConvert(String dateString) {
        if (V.isEmpty(dateString)) {
            return null;
        }
        if (!S.contains((CharSequence)(dateString = D.formatDateTimeString(dateString)), (CharSequence)" ")) {
            return D.convert2FormatDate(dateString, FORMAT_DATE_Y4MD);
        }
        return D.convert2FormatDate(dateString, FORMAT_DATETIME_Y4MDHMS);
    }

    public static LocalDate convert2LocalDate(String dateString) {
        if (V.isEmpty(dateString)) {
            return null;
        }
        dateString = D.formatDatePartString(dateString);
        return LocalDate.parse(dateString, FORMATTER_DATE_Y4MD);
    }

    public static LocalDateTime convert2LocalDateTime(String dateTimeString) {
        if (V.isEmpty((String)dateTimeString)) {
            return null;
        }
        if (((String)(dateTimeString = D.formatDateTimeString((String)dateTimeString))).length() <= FORMAT_DATE_Y4MD.length()) {
            dateTimeString = (String)dateTimeString + " 00:00:00";
        }
        return LocalDateTime.parse((CharSequence)dateTimeString, FORMATTER_DATETIME_Y4MDHMS);
    }

    @Deprecated
    public static String formatDateString(String dateTimeString) {
        return D.formatDateTimeString(dateTimeString);
    }

    public static String formatDateTimeString(String dateString) {
        if (V.isEmpty(dateString)) {
            return null;
        }
        String[] parts = dateString.contains("T") && !dateString.contains(" ") ? dateString.split("T") : dateString.split(" ");
        String datePart = D.formatDatePartString(parts[0]);
        if (parts.length > 1) {
            String timePart = D.formatTimePartString(parts[1]);
            return datePart + " " + timePart;
        }
        return datePart;
    }

    private static String formatDatePartString(String datePartStr) {
        Object[] ymd;
        if (V.isEmpty(datePartStr)) {
            return null;
        }
        if (S.contains((CharSequence)datePartStr, (CharSequence)" ")) {
            datePartStr = S.substringBefore((String)datePartStr, (String)" ");
        }
        if (S.contains((CharSequence)datePartStr, (CharSequence)"-")) {
            ymd = datePartStr.split("-");
            if (ymd.length == 3 && ymd[0].length() == 4) {
                return datePartStr;
            }
        } else {
            datePartStr = S.replaceEach((String)datePartStr, (String[])FORMAT_SEARCH_LIST, (String[])FORMAT_REPLACEMENT_LIST);
        }
        if ((ymd = datePartStr.split("-")).length >= 3) {
            if (ymd[2].length() == 4) {
                Object yyyy = ymd[2];
                Object month = ymd[0];
                Object day = ymd[1];
                ymd[0] = yyyy;
                ymd[1] = month;
                ymd[2] = day;
            }
            if (((String)ymd[0]).length() == 2) {
                ymd[0] = String.valueOf(Calendar.getInstance().get(1)).substring(0, 2) + (String)ymd[0];
            }
            if (((String)ymd[1]).length() == 1) {
                ymd[1] = "0" + (String)ymd[1];
            }
            if (((String)ymd[2]).length() == 1) {
                ymd[2] = "0" + (String)ymd[2];
            }
        }
        return S.join((Object[])ymd, (String)"-");
    }

    private static String formatTimePartString(String timePartStr) {
        if (V.isEmpty(timePartStr)) {
            return null;
        }
        String[] hms = timePartStr.split(":");
        if (hms.length == 3) {
            return timePartStr;
        }
        Object[] hmsArray = new String[3];
        if (hms[0].length() == 1) {
            hms[0] = "0" + hms[0];
        }
        hmsArray[0] = hms[0];
        if (hms.length >= 2) {
            if (hms[1].length() == 1) {
                hms[1] = "0" + hms[1];
            }
            hmsArray[1] = hms[1];
        } else {
            hmsArray[1] = "00";
        }
        if (hms.length >= 3) {
            if (hms[2].length() == 1) {
                hms[2] = "0" + hms[2];
            }
            hmsArray[2] = hms[2];
        } else {
            hmsArray[2] = "00";
        }
        return S.join((Object[])hmsArray, (String)":");
    }
}

