/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.parser.EntityInfoCache;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.V;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

@Component
@Lazy(value=false)
public class ContextHolder
implements ApplicationContextAware,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ContextHolder.class);
    private static ApplicationContext APPLICATION_CONTEXT = null;
    private static String DATABASE_TYPE = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        APPLICATION_CONTEXT = applicationContext;
        log.debug("ApplicationContext\u5df2\u8d4b\u503c: {}", (Object)APPLICATION_CONTEXT.getDisplayName());
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        APPLICATION_CONTEXT = event.getApplicationContext();
        log.debug("ApplicationContext\u5df2\u6ce8\u5165: {}", (Object)APPLICATION_CONTEXT.getDisplayName());
    }

    public static ApplicationContext getApplicationContext() {
        if (APPLICATION_CONTEXT == null) {
            log.debug("ApplicationContext\u672a\u521d\u59cb\u5316\uff0c\u901a\u8fc7ContextLoader\u83b7\u53d6!");
            APPLICATION_CONTEXT = ContextLoader.getCurrentWebApplicationContext();
        }
        if (APPLICATION_CONTEXT == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6ApplicationContext\uff0c\u8bf7\u786e\u4fddComponentScan\u626b\u63cf\u8def\u5f84\u5305\u542bcom.diboot\u5305\u8def\u5f84\uff0c\u5e76\u5728Spring\u521d\u59cb\u5316\u4e4b\u540e\u8c03\u7528\u63a5\u53e3!");
            new InvalidUsageException("\u68c0\u67e5\u8c03\u7528\u65f6\u673a", new Object[0]).printStackTrace();
        }
        return APPLICATION_CONTEXT;
    }

    public static Object getBean(String beanId) {
        return ContextHolder.getApplicationContext().getBean(beanId);
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)ContextHolder.getApplicationContext().getBean(clazz);
        }
        catch (Exception e) {
            log.debug("instance not found: {}", (Object)clazz.getSimpleName());
            return null;
        }
    }

    public static <T> List<T> getBeans(Class<T> type) {
        Map map = ContextHolder.getApplicationContext().getBeansOfType(type);
        if (V.isEmpty(map)) {
            return null;
        }
        ArrayList beanList = new ArrayList(map.size());
        beanList.addAll(map.values());
        return beanList;
    }

    public static List<Object> getBeansByAnnotation(Class<? extends Annotation> annotationType) {
        Map map = ContextHolder.getApplicationContext().getBeansWithAnnotation(annotationType);
        if (V.isEmpty(map)) {
            return null;
        }
        return new ArrayList<Object>(map.values());
    }

    public static IService getIServiceByEntity(Class entity) {
        IService iService;
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByClass(entity);
        IService iService2 = iService = entityInfoCache != null ? entityInfoCache.getService() : null;
        if (iService == null) {
            log.debug("\u672a\u80fd\u8bc6\u522b\u5230Entity: " + entity.getName() + " \u7684IService\u5b9e\u73b0\uff01");
        }
        return iService;
    }

    public static BaseService getBaseServiceByEntity(Class entity) {
        IService iService;
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByClass(entity);
        IService iService2 = iService = entityInfoCache != null ? entityInfoCache.getService() : null;
        if (iService == null) {
            log.debug("\u672a\u80fd\u8bc6\u522b\u5230Entity: {} \u7684Service\u5b9e\u73b0\uff01", (Object)entity.getName());
            return null;
        }
        if (iService instanceof BaseService) {
            return (BaseService)iService;
        }
        log.warn("Entity\u7684service\u5b9e\u73b0\u7c7b: {} \u975eBaseService\u5b9e\u73b0\uff01", (Object)entityInfoCache.getService());
        return null;
    }

    public static BaseMapper getBaseMapperByEntity(Class entityClass) {
        return ParserCache.getMapperInstance(entityClass);
    }

    public static String getIdColumnName(Class entity) {
        PropInfo propInfoCache = BindingCacheManager.getPropInfoByClass(entity);
        return propInfoCache != null ? propInfoCache.getIdColumn() : null;
    }

    public static String getIdFieldName(Class entity) {
        PropInfo propInfoCache = BindingCacheManager.getPropInfoByClass(entity);
        return propInfoCache != null ? propInfoCache.getIdFieldName() : null;
    }

    @Deprecated
    public static String getPrimaryKey(Class entity) {
        return ContextHolder.getIdFieldName(entity);
    }

    public static String getJdbcUrl() {
        ApplicationContext applicationContext = ContextHolder.getApplicationContext();
        if (applicationContext == null) {
            return null;
        }
        try {
            DataSource dataSource = (DataSource)applicationContext.getBean(DataSource.class);
            Connection connection = dataSource.getConnection();
            String jdbcUrl = connection.getMetaData().getURL();
            connection.close();
            return jdbcUrl;
        }
        catch (Exception e) {
            String urlConfigItem;
            String names;
            String master;
            log.warn("\u83b7\u53d6JDBC URL\u5f02\u5e38: {}", (Object)e.getMessage());
            Environment environment = applicationContext.getEnvironment();
            String jdbcUrl = environment.getProperty("spring.datasource.url");
            if (jdbcUrl == null) {
                jdbcUrl = environment.getProperty("spring.datasource.druid.url");
            }
            if (jdbcUrl == null && (master = environment.getProperty("spring.datasource.dynamic.primary")) != null) {
                jdbcUrl = environment.getProperty("spring.datasource.dynamic.datasource." + master + ".url");
            }
            if (jdbcUrl == null && (names = environment.getProperty("spring.shardingsphere.datasource.names")) != null) {
                jdbcUrl = environment.getProperty("spring.shardingsphere.datasource." + names.split(",")[0] + ".url");
            }
            if (jdbcUrl == null && (urlConfigItem = environment.getProperty("diboot.datasource.url.config")) != null) {
                jdbcUrl = environment.getProperty(urlConfigItem);
            }
            return jdbcUrl;
        }
    }

    public static String getDatabaseType() {
        if (DATABASE_TYPE != null) {
            return DATABASE_TYPE;
        }
        String jdbcUrl = ContextHolder.getJdbcUrl();
        if (jdbcUrl != null) {
            DbType dbType = JdbcUtils.getDbType((String)jdbcUrl);
            DATABASE_TYPE = dbType.getDb();
            if (DATABASE_TYPE.startsWith(DbType.SQL_SERVER.getDb())) {
                DATABASE_TYPE = DbType.SQL_SERVER.getDb();
            } else if (DATABASE_TYPE.startsWith(DbType.ORACLE_12C.getDb())) {
                DATABASE_TYPE = DbType.ORACLE.getDb();
            }
        }
        if (DATABASE_TYPE == null) {
            log.warn("\u65e0\u6cd5\u8bc6\u522b\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e:spring.datasource.url\u7b49");
        }
        return DATABASE_TYPE;
    }
}

