/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.serial.deserializer;

import com.diboot.core.util.D;
import com.diboot.core.util.V;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    private static final long serialVersionUID = 8758976191733673106L;

    public LocalDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        String dateString = (String)p.readValueAs(String.class);
        if (V.isEmpty(dateString)) {
            return null;
        }
        if ((dateString = D.formatDateTimeString(dateString)).length() <= "yyyy-MM-dd".length()) {
            return LocalDate.parse(dateString, D.FORMATTER_DATE_Y4MD).atStartOfDay();
        }
        return LocalDateTime.parse(dateString, D.FORMATTER_DATETIME_Y4MDHMS);
    }
}

