/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.handler;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class DefaultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public Object validExceptionHandler(Exception ex) {
        BindingResult br = null;
        if (ex instanceof BindException) {
            br = ((BindException)ex).getBindingResult();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (br != null && br.hasErrors()) {
            map.put("code", Status.FAIL_VALIDATION.code());
            String validateErrorMsg = V.getBindingError(br);
            map.put("msg", validateErrorMsg);
            map.put("ok", false);
            log.warn("\u6570\u636e\u6821\u9a8c\u5931\u8d25, {}: {}", (Object)br.getObjectName(), (Object)validateErrorMsg);
        }
        return new ResponseEntity(map, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    public Object handleException(HttpServletRequest request, Exception e) {
        Map<String, Object> map;
        HttpStatus status = this.getStatus(request);
        if (e instanceof BusinessException) {
            map = ((BusinessException)e).toMap();
        } else if (e.getCause() instanceof BusinessException) {
            map = ((BusinessException)e.getCause()).toMap();
        } else if (e instanceof InvalidUsageException) {
            map = ((InvalidUsageException)e).toMap();
        } else if (e.getCause() instanceof InvalidUsageException) {
            map = ((InvalidUsageException)e.getCause()).toMap();
        } else {
            map = new HashMap<String, Object>(8);
            map.put("code", status.value());
            String msg = this.buildMsg(status, e);
            map.put("msg", msg);
            map.put("ok", false);
        }
        log.warn("\u8bf7\u6c42\u5904\u7406\u5f02\u5e38", (Throwable)e);
        return new ResponseEntity(map, (HttpStatusCode)HttpStatus.OK);
    }

    protected String buildMsg(HttpStatus status, Exception e) {
        return e == null ? status.getReasonPhrase() : DefaultExceptionHandler.getRootCauseMessage(e);
    }

    protected HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        try {
            return HttpStatus.valueOf((int)statusCode);
        }
        catch (Exception ex) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    public static String getRootCauseMessage(Throwable t) {
        List list = ExceptionUtils.getThrowableList((Throwable)t);
        Assert.notEmpty((Collection)list, () -> "\u6ca1\u6709\u5f02\u5e38\u4fe1\u606f");
        return ((Throwable)list.get(list.size() - 1)).getMessage();
    }
}

