/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.handler;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.MultiDataPermissionHandler;
import com.diboot.core.data.access.DataAccessAnnoCache;
import com.diboot.core.data.access.DataScopeManager;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessControlHandler
implements MultiDataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(DataAccessControlHandler.class);
    private final Set<String> noCheckpointCache = new CopyOnWriteArraySet<String>();

    public Expression getSqlSegment(Table table, Expression where, String mappedStatementId) {
        if (this.noCheckpointCache.contains(mappedStatementId)) {
            return null;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)S.removeEsc(table.getName()));
        if (tableInfo == null || tableInfo.getEntityType() == null || !DataAccessAnnoCache.hasDataAccessCheckpoint(tableInfo.getEntityType())) {
            this.noCheckpointCache.add(mappedStatementId);
            return null;
        }
        return this.buildDataAccessExpression(table, tableInfo.getEntityType());
    }

    private Expression buildDataAccessExpression(Table mainTable, Class<?> entityClass) {
        return DataAccessAnnoCache.getDataPermissionMap(entityClass).entrySet().stream().map(entry -> {
            DataScopeManager checkImpl = ContextHolder.getBean(DataScopeManager.class);
            if (checkImpl == null) {
                throw new InvalidUsageException("\u65e0\u6cd5\u4ece\u4e0a\u4e0b\u6587\u4e2d\u83b7\u53d6\u6570\u636e\u6743\u9650\u7684\u63a5\u53e3\u5b9e\u73b0\uff1aDataAccessInterface", new Object[0]);
            }
            List<? extends Serializable> idValues = checkImpl.getAccessibleIds(entityClass, (String)entry.getKey());
            if (idValues == null) {
                return null;
            }
            Object idCol = (String)entry.getValue();
            if (mainTable.getAlias() != null) {
                idCol = mainTable.getAlias().getName() + "." + (String)idCol;
            }
            if (idValues.isEmpty()) {
                return new IsNullExpression().withLeftExpression((Expression)new Column((String)idCol));
            }
            if (idValues.size() == 1) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column((String)idCol));
                if (idValues.get(0) instanceof Long) {
                    equalsTo.setRightExpression((Expression)new LongValue(((Long)idValues.get(0)).longValue()));
                } else {
                    equalsTo.setRightExpression((Expression)new StringValue(S.defaultValueOf(idValues.get(0))));
                }
                return equalsTo;
            }
            String conditionExpr = (String)idCol + " IN ";
            conditionExpr = idValues.get(0) instanceof Long ? conditionExpr + "(" + S.join(idValues, (String)", ") + ")" : conditionExpr + "('" + S.join(idValues, (String)"', '") + "')";
            try {
                return CCJSqlParserUtil.parseCondExpression((String)conditionExpr);
            }
            catch (JSQLParserException e) {
                log.warn("\u89e3\u6790condition\u5f02\u5e38: " + conditionExpr, (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).reduce(AndExpression::new).orElse(null);
    }
}

