/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.exception;

import com.diboot.core.util.S;
import com.diboot.core.vo.Status;
import java.util.HashMap;
import java.util.Map;

public class BusinessException
extends RuntimeException {
    private Integer code;
    private Status status;

    public BusinessException() {
        super(Status.FAIL_OPERATION.label());
        this.status = Status.FAIL_OPERATION;
    }

    public BusinessException(Status status) {
        super(status.label());
        this.status = status;
    }

    public BusinessException(Status status, Throwable ex) {
        super(status.label(), ex);
        this.status = status;
    }

    public BusinessException(Status status, String msg, Object ... args) {
        super(status.label() + ": " + S.format(msg, args));
        this.status = status;
    }

    public BusinessException(int code, String msg) {
        super(msg);
        this.code = code;
    }

    public BusinessException(String msg, Object ... args) {
        super(S.format(msg, args));
        this.status = Status.FAIL_OPERATION;
    }

    public BusinessException(Status status, Throwable ex, String msg, Object ... args) {
        super(status.label() + ": " + S.format(msg, args), ex);
        this.status = status;
    }

    public BusinessException(int code, Throwable ex, String msg, Object ... args) {
        super(S.format(msg, args), ex);
        this.code = code;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("code", this.getCode());
        map.put("msg", this.getMessage());
        return map;
    }

    public Status getStatus() {
        return this.status;
    }

    private Integer getCode() {
        if (this.code == null && this.status != null) {
            this.code = this.status.code();
        }
        return this.code;
    }
}

