/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.data.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.parser.EntityInfoCache;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.data.query.BaseCriteria;
import com.diboot.core.data.query.CriteriaItem;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Pagination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCondition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(QueryCondition.class);
    private static final long serialVersionUID = -7495538662136985338L;
    protected List<CriteriaItem> criteriaList;
    protected Pagination pagination;
    protected List<String> orderItems;
    protected List<String> selectFields;
    protected List<String> excludeFields;
    protected Map<String, Object> queryParamMap;

    public QueryCondition() {
    }

    public QueryCondition(Map<String, Object> queryParamMap) {
        this.initQueryParamMap(queryParamMap, false);
    }

    public QueryCondition(Map<String, Object> queryParamMap, boolean includeEmpty) {
        this.initQueryParamMap(queryParamMap, includeEmpty);
    }

    private void initQueryParamMap(Map<String, Object> queryParamMap, boolean includeEmpty) {
        if (V.notEmpty(queryParamMap)) {
            for (Map.Entry<String, Object> entry : queryParamMap.entrySet()) {
                if (Pagination.isPaginationParam(entry.getKey())) continue;
                if (V.isEmpty(entry.getValue()) && !includeEmpty) {
                    log.debug("\u5ffd\u7565\u7a7a\u7684\u53c2\u6570: {}", (Object)entry.getKey());
                    continue;
                }
                this.addCriteria(entry.getKey(), Comparison.EQ, entry.getValue());
            }
        }
    }

    public <T, FT> QueryCondition select(SFunction<T, FT> ... fieldGetters) {
        if (this.selectFields == null) {
            this.selectFields = new ArrayList<String>();
        }
        for (SFunction<T, FT> getter : fieldGetters) {
            this.selectFields.add(BeanUtils.convertSFunctionToFieldName(getter));
        }
        return this;
    }

    public QueryCondition select(String ... fieldNames) {
        if (this.selectFields == null) {
            this.selectFields = new ArrayList<String>();
        }
        this.selectFields.addAll(Arrays.asList(fieldNames));
        return this;
    }

    public <T, FT> QueryCondition eq(SFunction<T, FT> fieldGetter, Object value) {
        if (value != null && value instanceof Collection) {
            return this.in(fieldGetter, value);
        }
        this.appendCriteria(fieldGetter, Comparison.EQ, value);
        return this;
    }

    public QueryCondition eq(String fieldName, Object value) {
        if (value != null && value instanceof Collection) {
            return this.in(fieldName, value);
        }
        this.appendCriteria(fieldName, Comparison.EQ, value);
        return this;
    }

    public <T, FT> QueryCondition ge(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.GE, value);
        return this;
    }

    public QueryCondition ge(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.GE, value);
        return this;
    }

    public <T, FT> QueryCondition gt(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.GT, value);
        return this;
    }

    public QueryCondition gt(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.GT, value);
        return this;
    }

    public <T, FT> QueryCondition between(SFunction<T, FT> fieldGetter, Object beginValue, Object endValue) {
        this.appendCriteria(fieldGetter, Comparison.BETWEEN, Arrays.asList(beginValue, endValue));
        return this;
    }

    public QueryCondition between(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.BETWEEN, value);
        return this;
    }

    public <T, FT> QueryCondition in(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.IN, value);
        return this;
    }

    public QueryCondition in(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.IN, value);
        return this;
    }

    public <T, FT> QueryCondition isNull(SFunction<T, FT> fieldGetter) {
        this.appendCriteria(fieldGetter, Comparison.IS_NULL, null);
        return this;
    }

    public QueryCondition isNull(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.IS_NULL, value);
        return this;
    }

    public <T, FT> QueryCondition isNotNull(SFunction<T, FT> fieldGetter) {
        this.appendCriteria(fieldGetter, Comparison.IS_NOT_NULL, null);
        return this;
    }

    public QueryCondition isNotNull(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.IS_NOT_NULL, value);
        return this;
    }

    public <T, FT> QueryCondition le(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.LE, value);
        return this;
    }

    public QueryCondition le(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.LE, value);
        return this;
    }

    public <T, FT> QueryCondition lt(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.LT, value);
        return this;
    }

    public QueryCondition lt(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.LT, value);
        return this;
    }

    public <T, FT> QueryCondition like(SFunction<T, FT> fieldGetter, Object value) {
        return this.contains(fieldGetter, value);
    }

    public QueryCondition like(String fieldName, Object value) {
        return this.contains(fieldName, value);
    }

    public <T, FT> QueryCondition contains(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.CONTAINS, value);
        return this;
    }

    public QueryCondition contains(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.CONTAINS, value);
        return this;
    }

    public <T, FT> QueryCondition endsWith(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.ENDSWITH, value);
        return this;
    }

    public QueryCondition endsWith(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.ENDSWITH, value);
        return this;
    }

    public <T, FT> QueryCondition startsWith(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.STARTSWITH, value);
        return this;
    }

    public QueryCondition startsWith(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.STARTSWITH, value);
        return this;
    }

    public <T, FT> QueryCondition ne(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.NOT_EQ, value);
        return this;
    }

    public QueryCondition ne(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.NOT_EQ, value);
        return this;
    }

    public <T, FT> QueryCondition notIn(SFunction<T, FT> fieldGetter, Object value) {
        this.appendCriteria(fieldGetter, Comparison.NOT_IN, value);
        return this;
    }

    public QueryCondition notIn(String fieldName, Object value) {
        this.appendCriteria(fieldName, Comparison.NOT_IN, value);
        return this;
    }

    public <T, FT> QueryCondition orderByDesc(SFunction<T, FT> fieldGetter) {
        return this.orderByDesc(BeanUtils.convertSFunctionToFieldName(fieldGetter));
    }

    public <T> QueryCondition orderByDesc(String fieldName) {
        if (this.orderItems == null) {
            this.orderItems = new ArrayList<String>();
        }
        this.orderItems.add(fieldName + ":DESC");
        return this;
    }

    public <T, FT> QueryCondition orderByAsc(SFunction<T, FT> fieldGetter) {
        return this.orderByAsc(BeanUtils.convertSFunctionToFieldName(fieldGetter));
    }

    public <T> QueryCondition orderByAsc(String fieldName) {
        if (this.orderItems == null) {
            this.orderItems = new ArrayList<String>();
        }
        this.orderItems.add(fieldName);
        return this;
    }

    public QueryCondition orderBy(String fieldName) {
        if (this.orderItems == null) {
            this.orderItems = new ArrayList<String>();
        }
        this.orderItems.add(fieldName);
        return this;
    }

    public <T, FT> QueryCondition appendCriteria(SFunction<T, FT> fieldGetter, Comparison comparison, Object value) {
        return this.appendCriteria(BeanUtils.convertSFunctionToFieldName(fieldGetter), comparison, value);
    }

    public <T, FT> QueryCondition appendCriteria(String fieldName, Comparison comparison, Object value) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<CriteriaItem>();
        }
        this.criteriaList.add(new CriteriaItem(fieldName, comparison, value));
        return this;
    }

    public <T, FT> QueryCondition updateCriteria(SFunction<T, FT> fieldGetter, Comparison comparison, Object value) {
        this.updateCriteria(BeanUtils.convertSFunctionToFieldName(fieldGetter), comparison, value);
        return this;
    }

    public <T, FT> QueryCondition removeCriteria(SFunction<T, FT> fieldGetter) {
        this.removeCriteria(BeanUtils.convertSFunctionToFieldName(fieldGetter));
        return this;
    }

    public QueryCondition addCriteria(CriteriaItem ... criteriaItems) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<CriteriaItem>();
        }
        this.criteriaList.addAll(Arrays.asList(criteriaItems));
        return this;
    }

    public QueryCondition addCriteria(String field, Object value) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<CriteriaItem>();
        }
        this.criteriaList.add(new CriteriaItem(field, value));
        return this;
    }

    public QueryCondition addCriteria(String field, Comparison comparison, Object value) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<CriteriaItem>();
        }
        this.criteriaList.add(new CriteriaItem(field, comparison, value));
        return this;
    }

    public QueryCondition addCriteria(BaseCriteria criteria) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<CriteriaItem>();
        }
        this.criteriaList.add(new CriteriaItem(criteria));
        return this;
    }

    public QueryCondition updateCriteria(String field, Comparison comparison, Object value) {
        if (this.criteriaList != null) {
            for (CriteriaItem item : this.criteriaList) {
                if (!item.getField().equals(field)) continue;
                item.setComparison(comparison.name()).setValue(value);
                return this;
            }
        }
        return this;
    }

    public QueryCondition removeCriteria(String field) {
        if (this.criteriaList != null) {
            for (CriteriaItem item : this.criteriaList) {
                if (!item.getField().equals(field)) continue;
                this.criteriaList.remove(item);
                return this;
            }
        }
        return this;
    }

    public Object getQueryParamVal(String field) {
        if (V.isEmpty(this.criteriaList)) {
            return null;
        }
        if (this.queryParamMap == null) {
            this.queryParamMap = new HashMap<String, Object>();
            this.criteriaList.forEach(c -> this.queryParamMap.put(c.getField(), c.getValue()));
        }
        return this.queryParamMap.get(field);
    }

    public boolean containsCriteria(String field) {
        if (V.isEmpty(this.criteriaList)) {
            return false;
        }
        for (CriteriaItem item : this.criteriaList) {
            if (!item.getField().equals(field)) continue;
            return true;
        }
        return false;
    }

    public CriteriaItem getCriteriaItem(String field) {
        if (V.isEmpty(this.criteriaList)) {
            return null;
        }
        for (CriteriaItem item : this.criteriaList) {
            if (!item.getField().equals(field)) continue;
            return item;
        }
        return null;
    }

    public QueryCondition clear() {
        this.criteriaList = null;
        this.orderItems = null;
        this.queryParamMap = null;
        return this;
    }

    public QueryCondition orderBy(List<String> orderItems) {
        this.orderItems = orderItems;
        return this;
    }

    public QueryCondition withPagination(Pagination pagination) {
        this.pagination = pagination;
        if (this.pagination == null) {
            this.pagination = new Pagination();
        } else {
            String orderByStr = this.pagination.getOrderBy();
            this.orderItems = V.notEmpty(orderByStr) ? S.splitToList(orderByStr, ",") : Collections.singletonList(Pagination.ORDER_BY_ID_DESC);
        }
        return this;
    }

    public <T> QueryWrapper<T> toQueryWrapper(Class<T> entityClass) {
        EntityInfoCache entityInfo = BindingCacheManager.getEntityInfoByClass(entityClass);
        QueryWrapper query = Wrappers.query();
        if (V.notEmpty(this.selectFields)) {
            query.select(this.selectFields.stream().map(entityInfo::getColumnByField).collect(Collectors.toList()));
        }
        if (V.notEmpty(this.criteriaList)) {
            for (CriteriaItem criteriaItem : this.criteriaList) {
                String field = entityInfo.getColumnByField(criteriaItem.getField());
                Object value = criteriaItem.getValue();
                switch (criteriaItem.getComparison()) {
                    case EQ: {
                        query.eq((Object)field, value);
                        break;
                    }
                    case IN: {
                        if (value instanceof Collection) {
                            query.in((Object)field, (Collection)value);
                            break;
                        }
                        if (value.getClass().isArray()) {
                            query.in((Object)field, (Object[])value);
                            break;
                        }
                        query.eq((Object)field, value);
                        break;
                    }
                    case STARTSWITH: {
                        query.likeRight((Object)field, value);
                        break;
                    }
                    case ENDSWITH: {
                        query.likeLeft((Object)field, value);
                        break;
                    }
                    case LIKE: 
                    case CONTAINS: {
                        query.like((Object)field, value);
                        break;
                    }
                    case GT: {
                        query.gt((Object)field, value);
                        break;
                    }
                    case GE: {
                        query.ge((Object)field, value);
                        break;
                    }
                    case LT: {
                        query.lt((Object)field, value);
                        break;
                    }
                    case LE: {
                        query.le((Object)field, value);
                        break;
                    }
                    case BETWEEN: {
                        break;
                    }
                    case BETWEEN_BEGIN: {
                        break;
                    }
                    case BETWEEN_END: {
                        break;
                    }
                    case NOT_EQ: {
                        query.ne((Object)field, value);
                        break;
                    }
                    case NOT_IN: {
                        if (value instanceof Collection) {
                            query.notIn((Object)field, (Collection)value);
                            break;
                        }
                        if (value.getClass().isArray()) {
                            query.notIn((Object)field, (Object[])value);
                            break;
                        }
                        query.ne((Object)field, value);
                        break;
                    }
                    case IS_NULL: {
                        query.isNull((Object)field);
                        break;
                    }
                    case IS_NOT_NULL: {
                        query.isNotNull((Object)field);
                        break;
                    }
                }
            }
        }
        if (V.notEmpty(this.orderItems)) {
            for (String field : this.orderItems) {
                V.securityCheck(field);
                if (field.contains(":")) {
                    String[] fieldAndOrder = S.split((String)field, (String)":");
                    String columnName = entityInfo.getColumnByField(fieldAndOrder[0]);
                    if ("DESC".equalsIgnoreCase(fieldAndOrder[1])) {
                        query.orderByDesc((Object)columnName);
                        continue;
                    }
                    query.orderByAsc((Object)columnName);
                    continue;
                }
                query.orderByAsc((Object)S.toSnakeCase(field));
            }
        }
        return query;
    }

    public boolean isDefaultOrder() {
        return V.notEmpty(this.orderItems) && this.orderItems.size() == 1 && this.orderItems.get(0).equals(Pagination.ORDER_BY_ID_DESC);
    }

    public List<CriteriaItem> getCriteriaList() {
        return this.criteriaList;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public QueryCondition setPagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    public List<String> getOrderItems() {
        return this.orderItems;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public QueryCondition setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
        return this;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public QueryCondition setExcludeFields(List<String> excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }
}

