/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.data.protect;

import com.diboot.core.data.annotation.DataMask;
import com.diboot.core.data.protect.DataMaskHandler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveInfoSerialize<E>
extends JsonSerializer<E>
implements ContextualSerializer {
    private static final Logger log = LoggerFactory.getLogger(SensitiveInfoSerialize.class);
    private DataMaskHandler dataMaskHandler;
    private Class<?> clazz;
    private String fieldName;

    public SensitiveInfoSerialize() {
    }

    public SensitiveInfoSerialize(Class<?> clazz, String fieldName) {
        this.clazz = clazz;
        this.fieldName = fieldName;
    }

    public void serialize(E value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.dataMaskHandler == null) {
            this.dataMaskHandler = ContextHolder.getBean(DataMaskHandler.class);
            if (this.dataMaskHandler == null) {
                throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6 DataMaskHandler \u6570\u636e\u8131\u654f\u7684\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\uff01", new Object[0]);
            }
        }
        if (value instanceof List) {
            gen.writeObject(((List)value).stream().map(e -> this.dataMaskHandler.mask((String)e)).collect(Collectors.toList()));
        } else {
            gen.writeObject((Object)this.dataMaskHandler.mask((String)value));
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (null == property) {
            return prov.findNullValueSerializer(null);
        }
        Class rawClass = property.getType().getRawClass();
        if (rawClass == String.class || rawClass == List.class && property.getType().getContentType().getRawClass() == String.class) {
            DataMask protect = (DataMask)property.getAnnotation(DataMask.class);
            if (null == protect) {
                protect = (DataMask)property.getContextAnnotation(DataMask.class);
            }
            if (null != protect) {
                return new SensitiveInfoSerialize<E>(property.getMember().getDeclaringClass(), property.getName());
            }
        } else {
            log.error("`@DataMask` \u53ea\u652f\u6301 String \u4e0e List<String> \u7c7b\u578b\u8131\u654f\uff01");
        }
        return prov.findValueSerializer(property.getType(), property);
    }
}

