/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.config.Cons;
import com.diboot.core.controller.BaseController;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Pagination;
import com.diboot.core.vo.Status;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCrudRestController<E extends AbstractEntity>
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseCrudRestController.class);
    private Class<E> entityClass;

    protected <VO> JsonResult<VO> getViewObject(Serializable id, Class<VO> voClass) throws Exception {
        VO vo = this.getService().getViewObject(id, voClass);
        return this.ok(vo);
    }

    protected E getEntity(Serializable id) throws Exception {
        return (E)((AbstractEntity)this.getService().getEntity(id));
    }

    protected <VO> JsonResult<List<VO>> getViewObjectList(E entity, Pagination pagination, Class<VO> voClass) throws Exception {
        QueryWrapper<E> queryWrapper = super.buildQueryWrapperByDTO(entity);
        if (pagination != null && V.isEmpty(pagination.getOrderBy())) {
            pagination.setOrderBy(Pagination.ORDER_BY_ID_DESC);
        }
        List<VO> voList = this.getService().getViewObjectList((Wrapper)queryWrapper, pagination, voClass);
        return JsonResult.OK(voList).bindPagination(pagination);
    }

    @Deprecated
    protected <VO> JsonResult<List<VO>> getViewObjectList(E entity, Pagination pagination, Class<VO> voClass, boolean buildQueryWrapperByDTO) throws Exception {
        QueryWrapper<E> queryWrapper = buildQueryWrapperByDTO ? super.buildQueryWrapperByDTO(entity) : super.buildQueryWrapperByQueryParams(entity);
        List<VO> voList = this.getService().getViewObjectList((Wrapper)queryWrapper, pagination, voClass);
        return JsonResult.OK(voList).bindPagination(pagination);
    }

    protected JsonResult<List<E>> getEntityList(Wrapper<?> queryWrapper) throws Exception {
        List<E> entityList = this.getService().getEntityList(queryWrapper);
        return JsonResult.OK(entityList);
    }

    protected JsonResult<List<E>> getEntityListWithPaging(Wrapper<?> queryWrapper, Pagination pagination) throws Exception {
        List<E> entityList = this.getService().getEntityList(queryWrapper, pagination);
        return JsonResult.OK(entityList).bindPagination(pagination);
    }

    protected JsonResult<?> createEntity(E entity) throws Exception {
        this.beforeCreate(entity);
        boolean success = this.getService().createEntity(entity);
        if (success) {
            this.afterCreated(entity);
            return JsonResult.OK(((AbstractEntity)entity).getPrimaryKeyVal());
        }
        log.warn("\u521b\u5efa\u64cd\u4f5c\u672a\u6210\u529f\uff0centity=" + entity.getClass().getSimpleName());
        return this.failOperation();
    }

    protected JsonResult<?> updateEntity(Serializable id, E entity) throws Exception {
        if (((AbstractEntity)entity).getId() == null) {
            String pk = ContextHolder.getIdFieldName(this.getEntityClass());
            if (Cons.FieldName.id.name().equals(pk)) {
                ((AbstractEntity)entity).setId((Serializable)id);
            } else if (BeanUtils.getProperty(entity, pk) == null) {
                BeanUtils.setProperty(entity, pk, id);
            }
        }
        this.beforeUpdate(entity);
        boolean success = this.getService().updateEntity(entity);
        if (success) {
            this.afterUpdated(entity);
            return JsonResult.OK();
        }
        log.warn("\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25\uff0c{}:{}", (Object)entity.getClass().getSimpleName(), ((AbstractEntity)entity).getId());
        return this.failOperation();
    }

    protected JsonResult<?> deleteEntity(Serializable id) throws Exception {
        if (id == null) {
            return this.failInvalidParam("\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6761\u76ee\uff01");
        }
        this.beforeDelete(id);
        boolean success = this.getService().deleteEntity(id);
        if (success) {
            this.afterDeleted(id);
            log.info("\u5220\u9664\u64cd\u4f5c\u6210\u529f\uff0c{}:{}", (Object)this.getEntityClass().getSimpleName(), (Object)id);
            return JsonResult.OK();
        }
        log.warn("\u5220\u9664\u64cd\u4f5c\u672a\u6210\u529f\uff0c{}:{}", (Object)this.getEntityClass().getSimpleName(), (Object)id);
        return this.failOperation();
    }

    protected JsonResult<?> batchDeleteEntities(Collection<? extends Serializable> ids) throws Exception {
        if (V.isEmpty(ids)) {
            return this.failInvalidParam("\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6761\u76ee\uff01");
        }
        this.beforeBatchDelete(ids);
        boolean success = this.getService().deleteEntities(ids);
        if (success) {
            this.afterBatchDeleted(ids);
            log.info("\u5220\u9664\u64cd\u4f5c\u6210\u529f\uff0c{}:{}", (Object)this.getEntityClass().getSimpleName(), (Object)S.join(ids));
            return this.ok();
        }
        log.warn("\u5220\u9664\u64cd\u4f5c\u672a\u6210\u529f\uff0c{}:{}", (Object)this.getEntityClass().getSimpleName(), (Object)S.join(ids));
        return this.failOperation();
    }

    protected JsonResult<?> ok() {
        return JsonResult.OK();
    }

    protected <T> JsonResult<T> ok(T data) {
        return JsonResult.OK(data);
    }

    protected JsonResult<?> failOperation() {
        return new JsonResult(Status.FAIL_OPERATION);
    }

    protected JsonResult<?> failOperation(String msg) {
        return JsonResult.FAIL_OPERATION(msg);
    }

    protected JsonResult<?> failInvalidParam() {
        return new JsonResult(Status.FAIL_INVALID_PARAM);
    }

    protected JsonResult<?> failInvalidParam(String msg) {
        return JsonResult.FAIL_INVALID_PARAM(msg);
    }

    protected JsonResult<?> fail(Status status, String msg) {
        return new JsonResult(status).msg(msg);
    }

    protected void beforeCreate(E entityOrDto) throws Exception {
    }

    protected void afterCreated(E entityOrDto) throws Exception {
    }

    protected void beforeUpdate(E entityOrDto) throws Exception {
        BeanUtils.clearFieldValue(entityOrDto, BindingCacheManager.getPropInfoByClass(this.getEntityClass()).getFillUpdateFieldList());
    }

    protected void afterUpdated(E entityOrDto) throws Exception {
    }

    protected void beforeDelete(Serializable id) throws Exception {
    }

    protected void afterDeleted(Serializable id) throws Exception {
    }

    protected void beforeBatchDelete(Collection<? extends Serializable> ids) throws Exception {
    }

    protected void afterBatchDeleted(Collection<? extends Serializable> ids) throws Exception {
    }

    protected BaseService<E> getService() {
        return ContextHolder.getBaseServiceByEntity(this.getEntityClass());
    }

    protected Class<E> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = BeanUtils.getGenericityClass(this, 0);
            if (this.entityClass == null) {
                log.warn("\u65e0\u6cd5\u4ece {} \u7c7b\u5b9a\u4e49\u4e2d\u83b7\u53d6\u6cdb\u578b\u7c7bentityClass", (Object)this.getClass().getName());
            }
        }
        return this.entityClass;
    }
}

