/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.binding.Binder;
import com.diboot.core.binding.QueryBuilder;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.helper.WrapperHelper;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.config.Cons;
import com.diboot.core.data.query.BaseCriteria;
import com.diboot.core.dto.RelatedDataDTO;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Pagination;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

public class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected HttpServletRequest request;

    protected <DTO> QueryWrapper<DTO> buildQueryWrapperByDTO(DTO entityOrDto) throws Exception {
        return QueryBuilder.toQueryWrapper(entityOrDto);
    }

    protected <DTO> QueryWrapper<DTO> buildQueryWrapperByDTO(DTO entityOrDto, Pagination pagination) throws Exception {
        return QueryBuilder.toQueryWrapper(entityOrDto, pagination);
    }

    @Deprecated
    protected <DTO> QueryWrapper<DTO> buildQueryWrapperByQueryParams(DTO entityOrDto) throws Exception {
        return QueryBuilder.toQueryWrapper(entityOrDto, this.extractQueryParams());
    }

    @Deprecated
    protected <DTO> QueryWrapper<DTO> buildQueryWrapperByQueryParams(DTO entityOrDto, Pagination pagination) throws Exception {
        return QueryBuilder.toQueryWrapper(entityOrDto, this.extractQueryParams(), pagination);
    }

    protected Map<String, Object> getParamsMap() throws Exception {
        return this.getParamsMap(null);
    }

    private Map<String, Object> getParamsMap(List<String> paramList) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] values;
            String paramName = (String)paramNames.nextElement();
            if (V.notEmpty(paramList) && !paramList.contains(paramName) || !V.notEmpty(values = this.request.getParameterValues(paramName))) continue;
            if (values.length == 1) {
                if (!V.notEmpty(values[0])) continue;
                String paramValue = URLDecoder.decode(values[0], "UTF-8");
                result.put(paramName, paramValue);
                continue;
            }
            String[] valueArray = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valueArray[i] = URLDecoder.decode(values[i], "UTF-8");
            }
            result.put(paramName, valueArray);
        }
        return result;
    }

    protected String getRequestMappingURI() {
        String contextPath = this.request.getContextPath();
        if (V.notEmpty(contextPath)) {
            return S.replace((String)this.request.getRequestURI(), (String)contextPath, (String)"");
        }
        return this.request.getRequestURI();
    }

    protected Set<String> extractQueryParams() {
        Map<String, Object> paramValueMap = this.convertParams2Map();
        if (V.notEmpty(paramValueMap)) {
            return paramValueMap.keySet();
        }
        return Collections.EMPTY_SET;
    }

    protected Map<String, Object> convertParams2Map() {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (this.request == null) {
            return result;
        }
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] values = this.request.getParameterValues(paramName);
            if (!V.notEmpty(values)) continue;
            if (values.length == 1) {
                if (!V.notEmpty(values[0])) continue;
                result.put(paramName, values[0]);
                continue;
            }
            result.put(paramName, values);
        }
        return result;
    }

    @Deprecated
    protected <VO> List<VO> convertToVoAndBindRelations(List entityList, Class<VO> voClass) {
        List<VO> voList = Binder.convertAndBindRelations(entityList, voClass);
        return voList;
    }

    protected List<LabelValue> loadRelatedData(RelatedDataDTO relatedDataDTO) {
        return this.loadRelatedData(relatedDataDTO, null, null);
    }

    protected List<LabelValue> loadRelatedData(RelatedDataDTO relatedDataDTO, @Nullable String parentId, @Nullable String keyword) {
        V.securityCheck(relatedDataDTO.getType(), relatedDataDTO.getLabel(), relatedDataDTO.getExt(), relatedDataDTO.getOrderBy(), relatedDataDTO.getParent(), relatedDataDTO.getParentPath());
        if (!this.relatedDataSecurityCheck(relatedDataDTO)) {
            log.warn("relatedData\u5b89\u5168\u68c0\u67e5\u4e0d\u901a\u8fc7: {}", (Object)JSON.stringify(relatedDataDTO));
            return Collections.emptyList();
        }
        String entityClassName = relatedDataDTO.getTypeClassName();
        Class<?> entityClass = BindingCacheManager.getEntityClassBySimpleName(entityClassName);
        if (V.isEmpty(entityClass)) {
            throw new BusinessException("relatedData: " + relatedDataDTO.getType() + " \u4e0d\u5b58\u5728", new Object[0]);
        }
        BaseService baseService = ContextHolder.getBaseServiceByEntity(entityClass);
        if (baseService == null) {
            throw new BusinessException("relatedData: " + relatedDataDTO.getType() + " \u7684Service\u4e0d\u5b58\u5728 ", new Object[0]);
        }
        PropInfo propInfoCache = BindingCacheManager.getPropInfoByClass(entityClass);
        Function<String, String> field2column = field -> {
            if (V.notEmpty(field)) {
                String column = propInfoCache.getColumnByField((String)field);
                if (V.notEmpty(column)) {
                    return column;
                }
                throw new BusinessException("relatedData: " + relatedDataDTO.getType() + " \u65e0 `" + field + "` \u5c5e\u6027", new Object[0]);
            }
            return null;
        };
        String label = field2column.apply((String)S.defaultIfBlank((CharSequence)relatedDataDTO.getLabel(), (CharSequence)"label"));
        final String idColumn = propInfoCache.getIdColumn();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(label);
        columns.add(idColumn);
        if (V.notEmpty(relatedDataDTO.getExt())) {
            columns.add(field2column.apply(relatedDataDTO.getExt()));
        }
        QueryWrapper queryWrapper = Wrappers.query();
        WrapperHelper.buildOrderBy(queryWrapper, relatedDataDTO.getOrderBy(), field2column);
        if (V.notEmpty(relatedDataDTO.getParent())) {
            boolean isDynamicRoot;
            Serializable rootId;
            String parentColumn = field2column.apply(relatedDataDTO.getParent());
            Class<?> parentFieldType = propInfoCache.getFieldTypeByColumn(parentColumn);
            final Function<String, Serializable> parentIdTypeConversion = pid -> V.isEmpty(pid) ? null : (parentFieldType == Long.class ? Long.valueOf(pid) : pid);
            final String parentPathColumn = field2column.apply(relatedDataDTO.getParentPath());
            if (V.notEmpty(relatedDataDTO.getConditions())) {
                Optional<BaseCriteria> parentCriteriaOpt = relatedDataDTO.getConditions().stream().filter(criteria -> criteria.getField().equals(relatedDataDTO.getParent())).findFirst();
                if (parentCriteriaOpt.isPresent()) {
                    rootId = parentIdTypeConversion.apply(S.valueOf(parentCriteriaOpt.get().getValue()));
                    relatedDataDTO.removeCondition(relatedDataDTO.getParent());
                } else {
                    rootId = null;
                }
            } else {
                rootId = null;
            }
            boolean bl = isDynamicRoot = !parentIdTypeConversion.apply("0").equals(rootId) && V.isNoneEmpty(rootId, parentPathColumn);
            if (isDynamicRoot) {
                Object rootNode = baseService.getEntity(rootId);
                if (rootNode == null) {
                    return Collections.emptyList();
                }
                String parentPath = S.valueOf(BeanUtils.getProperty(rootNode, relatedDataDTO.getParentPath()));
                queryWrapper.and(query -> {
                    query.likeRight((Object)parentPathColumn, V.isEmpty(parentPath) ? S.valueOf(rootId) : parentPath + "," + rootId);
                    ((QueryWrapper)query.or()).eq((Object)idColumn, (Object)rootId);
                });
            }
            if (V.notEmpty(parentId)) {
                queryWrapper.eq((Object)parentColumn, (Object)parentIdTypeConversion.apply(parentId));
            } else if (V.isNoneEmpty(keyword, relatedDataDTO.getParentPath())) {
                final List<Map<String, Object>> mapList = baseService.getMapList((Wrapper)((QueryWrapper)Wrappers.query().select((Object[])new String[]{idColumn, parentPathColumn})).like((Object)label, (Object)keyword));
                if (V.isEmpty(mapList)) {
                    return Collections.emptyList();
                }
                queryWrapper.in((Object)idColumn, (Collection)new HashSet<Serializable>(){
                    {
                        this.addAll(mapList.stream().peek(map -> this.add((Serializable)parentIdTypeConversion.apply(S.valueOf(map.remove(idColumn))))).map(map -> S.split(S.valueOf(map.get(parentPathColumn)))).flatMap(Stream::of).filter(V::notEmpty).map(parentIdTypeConversion).collect(Collectors.toList()));
                    }
                });
                columns.add(S.joinWith((String)" as ", (Object[])new Object[]{parentColumn, Cons.FieldName.parentId.name()}));
            } else if (relatedDataDTO.isLazyChild()) {
                if (isDynamicRoot) {
                    queryWrapper.eq((Object)idColumn, (Object)rootId);
                } else {
                    Serializable treeRootId = this.getTreeRootId(entityClass, parentFieldType);
                    if (treeRootId == null) {
                        queryWrapper.isNull((Object)parentColumn);
                    } else {
                        queryWrapper.eq((Object)parentColumn, (Object)treeRootId);
                    }
                }
            } else {
                columns.add(S.joinWith((String)" as ", (Object[])new Object[]{parentColumn, Cons.FieldName.parentId.name()}));
            }
        } else {
            queryWrapper.like(V.notEmpty(keyword), (Object)label, (Object)keyword);
        }
        this.buildRelatedDataCondition(relatedDataDTO, queryWrapper, field2column);
        List<LabelValue> labelValueList = baseService.getLabelValueList((Wrapper)queryWrapper.select((Object[])columns.toArray(new String[0])));
        if (V.isEmpty(keyword) && labelValueList.size() > BaseConfig.getBatchSize()) {
            log.warn("relatedData: {} \u6570\u636e\u91cf\u8d85\u8fc7 {} \u6761, \u5efa\u8bae\u91c7\u7528\u8fdc\u7a0b\u641c\u7d22\u63a5\u53e3\u8fc7\u6ee4\u6570\u636e", (Object)entityClassName, (Object)BaseConfig.getBatchSize());
        }
        return labelValueList;
    }

    protected Serializable getTreeRootId(Class<?> entityClass, Class<?> parentFieldType) {
        return parentFieldType == Long.class ? Long.valueOf(0L) : "0";
    }

    protected boolean relatedDataSecurityCheck(RelatedDataDTO relatedDataDTO) {
        return true;
    }

    protected void buildRelatedDataCondition(RelatedDataDTO relatedDataDTO, QueryWrapper<?> queryWrapper, Function<String, String> field2column) {
        if (V.isEmpty(relatedDataDTO.getConditions())) {
            return;
        }
        relatedDataDTO.getConditions().forEach(criteria -> {
            String columnName = (String)field2column.apply(criteria.getField());
            WrapperHelper.buildQueryCriteria(queryWrapper, criteria.getComparison(), columnName, criteria.getValue());
        });
    }

    protected void dumpParams() {
        Map params = this.request.getParameterMap();
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : params.entrySet()) {
                String[] values = (String[])entry.getValue();
                if (values == null || values.length <= 0) continue;
                sb.append((String)entry.getKey()).append("=").append(S.join(values)).append("; ");
            }
            log.debug(sb.toString());
        }
    }

    protected Long getLong(String param) {
        return S.toLong(this.request.getParameter(param));
    }

    protected long getLong(String param, Long defaultValue) {
        return S.toLong(this.request.getParameter(param), defaultValue);
    }

    protected Integer getInteger(String param) {
        return S.toInt(this.request.getParameter(param));
    }

    protected int getInt(String param, Integer defaultValue) {
        return S.toInt(this.request.getParameter(param), defaultValue);
    }

    protected boolean getBoolean(String param) {
        return S.toBoolean(this.request.getParameter(param));
    }

    protected boolean getBoolean(String param, boolean defaultBoolean) {
        return S.toBoolean(this.request.getParameter(param), defaultBoolean);
    }

    protected Double getDouble(String param) {
        if (V.notEmpty(this.request.getParameter(param))) {
            return Double.parseDouble(this.request.getParameter(param));
        }
        return null;
    }

    protected Double getDouble(String param, Double defaultValue) {
        if (V.notEmpty(this.request.getParameter(param))) {
            return Double.parseDouble(this.request.getParameter(param));
        }
        return defaultValue;
    }

    protected String getString(String param) {
        if (V.notEmpty(this.request.getParameter(param))) {
            return this.request.getParameter(param);
        }
        return null;
    }

    protected String getString(String param, String defaultValue) {
        if (V.notEmpty(this.request.getParameter(param))) {
            return this.request.getParameter(param);
        }
        return defaultValue;
    }

    protected String[] getStringArray(String param) {
        if (this.request.getParameterValues(param) != null) {
            return this.request.getParameterValues(param);
        }
        return null;
    }

    protected List<String> getStringList(String param) {
        String[] strArray = this.getStringArray(param);
        if (V.isEmpty(strArray)) {
            return null;
        }
        return Arrays.asList(strArray);
    }

    protected List<Long> getLongList(String param) {
        String[] strArray = this.getStringArray(param);
        if (V.isEmpty(strArray)) {
            return null;
        }
        ArrayList<Long> longList = new ArrayList<Long>();
        for (String str : strArray) {
            if (!V.notEmpty(str)) continue;
            longList.add(Long.parseLong(str));
        }
        return longList;
    }
}

