/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.config;

import com.diboot.core.util.PropertiesUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfig {
    private static final Logger log = LoggerFactory.getLogger(BaseConfig.class);
    private static Integer cutLength = null;
    private static Integer pageSize = null;
    private static Integer batchSize = null;
    private static Object ACTIVE_FLAG_VALUE = null;
    private static Long workerId = null;
    private static Long dataCenterId = null;

    public static String getProperty(String key) {
        return PropertiesUtils.get(key);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PropertiesUtils.get(key);
        return value != null ? value : defaultValue;
    }

    public static boolean isTrue(String key) {
        return PropertiesUtils.getBoolean(key);
    }

    public static Integer getInteger(String key) {
        return PropertiesUtils.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue) {
        Integer value = PropertiesUtils.getInteger(key);
        return value != null ? value : defaultValue;
    }

    public static int getCutLength() {
        if (cutLength == null && (cutLength = PropertiesUtils.getInteger("diboot.core.cut-length")) == null) {
            cutLength = 20;
        }
        return cutLength;
    }

    public static int getPageSize() {
        if (pageSize == null && (pageSize = PropertiesUtils.getInteger("diboot.core.page-size")) == null) {
            pageSize = 20;
        }
        return pageSize;
    }

    public static int getBatchSize() {
        if (batchSize == null && (batchSize = PropertiesUtils.getInteger("diboot.core.batch-size")) == null) {
            batchSize = 1000;
        }
        return batchSize;
    }

    public static Object getActiveFlagValue() {
        String activeValue = BaseConfig.getProperty("mybatis-plus.global-config.db-config.logic-not-delete-value");
        BaseConfig.initActiveFlagValue(activeValue);
        return ACTIVE_FLAG_VALUE;
    }

    public static void setActiveFlagValue(String value) {
        BaseConfig.initActiveFlagValue(value);
    }

    private static void initActiveFlagValue(String activeValue) {
        if (ACTIVE_FLAG_VALUE == null && V.notEmpty(activeValue)) {
            ACTIVE_FLAG_VALUE = S.equalsIgnoreCase((CharSequence)activeValue, (CharSequence)"false") ? Boolean.valueOf(false) : (S.containsIgnoreCase((CharSequence)activeValue, (CharSequence)"true") ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(Integer.parseInt(activeValue)));
        }
        if (ACTIVE_FLAG_VALUE == null) {
            ACTIVE_FLAG_VALUE = 0;
        }
    }

    public static long getWorkerId() {
        if (workerId == null && (workerId = PropertiesUtils.getLong("diboot.id.worker-id")) == null) {
            workerId = 1L;
        }
        return workerId;
    }

    public static long getDataCenterId() {
        if (dataCenterId == null && (dataCenterId = PropertiesUtils.getLong("diboot.id.data-center-id")) == null) {
            dataCenterId = 1L;
        }
        return dataCenterId;
    }
}

