/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.cache;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.exception.InvalidUsageException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DynamicRedisCacheManager
extends SimpleCacheManager
implements BaseCacheManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicRedisCacheManager.class);
    private RedisCacheManager redisCacheManager;

    public DynamicRedisCacheManager(RedisCacheManager redisCacheManager) {
        this.redisCacheManager = redisCacheManager;
    }

    public DynamicRedisCacheManager(RedisTemplate redisTemplate, Map<String, Integer> cacheName2ExpiredMinutes) {
        RedisCacheManager.RedisCacheManagerBuilder builder = RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)redisTemplate.getConnectionFactory());
        for (Map.Entry<String, Integer> entry : cacheName2ExpiredMinutes.entrySet()) {
            RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisTemplate.getStringSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisTemplate.getValueSerializer())).entryTtl(Duration.ofMinutes(entry.getValue().intValue()));
            builder.withCacheConfiguration(entry.getKey(), cacheConfiguration);
        }
        this.redisCacheManager = builder.transactionAware().build();
        this.redisCacheManager.initializeCaches();
        log.info("redisCacheManager \u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Override
    public <T> T getCacheObj(String cacheName, Object objKey, Class<T> tClass) {
        Object cacheObj;
        Cache cache = this.redisCacheManager.getCache(cacheName);
        Object object = cacheObj = cache != null ? cache.get(objKey, tClass) : null;
        if (log.isTraceEnabled()) {
            log.trace("\u4ece\u7f13\u5b58\u8bfb\u53d6: {}.{} = {}", new Object[]{cacheName, objKey, cacheObj});
        }
        return (T)cacheObj;
    }

    @Override
    public <T> T getCacheObj(String cacheName, Object objKey, Callable<T> initSupplier) {
        Object cacheObj;
        Cache cache = this.redisCacheManager.getCache(cacheName);
        Object object = cacheObj = cache != null ? cache.get(objKey, initSupplier) : null;
        if (log.isTraceEnabled()) {
            log.trace("\u4ece\u7f13\u5b58\u8bfb\u53d6: {}.{} = {}", new Object[]{cacheName, objKey, cacheObj});
        }
        return (T)cacheObj;
    }

    @Override
    public String getCacheString(String cacheName, Object objKey) {
        return this.getCacheObj(cacheName, objKey, String.class);
    }

    @Override
    public void putCacheObj(String cacheName, Object objKey, Object obj) {
        Cache cache = this.redisCacheManager.getCache(cacheName);
        if (cache == null) {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6cache\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316", cacheName);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7f13\u5b58: {} \u65b0\u589e-> {}", (Object)cacheName, objKey);
        }
        cache.put(objKey, obj);
    }

    @Override
    public void removeCacheObj(String cacheName, Object objKey) {
        Cache cache = this.redisCacheManager.getCache(cacheName);
        if (cache == null) {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6cache\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316", cacheName);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7f13\u5b58: {} \u79fb\u9664-> {}", (Object)cacheName, objKey);
        }
        cache.evict(objKey);
    }

    @Override
    public boolean isUninitializedCache(String cacheName) {
        return false;
    }

    @Override
    public void clearOutOfDateData(String cacheName) {
    }
}

