/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.cache;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.cache.BaseMemoryCacheManager;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.V;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;

public class DynamicMemoryCacheManager
extends BaseMemoryCacheManager
implements BaseCacheManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicMemoryCacheManager.class);
    private final ConcurrentHashMap<String, String> CACHE_CLEANDATE_CACHE = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> CACHE_EXPIREDMINUTES_CACHE = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<Object, Long>> CACHE_TIMESTAMP_CACHE = new ConcurrentHashMap();

    public DynamicMemoryCacheManager() {
    }

    public DynamicMemoryCacheManager(String ... cacheNames) {
        ArrayList<ConcurrentMapCache> caches = new ArrayList<ConcurrentMapCache>(cacheNames.length);
        for (String cacheName : cacheNames) {
            caches.add(new ConcurrentMapCache(cacheName));
        }
        this.setCaches(caches);
    }

    public DynamicMemoryCacheManager(int expiredMinutes, String ... cacheNames) {
        ArrayList<ConcurrentMapCache> caches = new ArrayList<ConcurrentMapCache>(cacheNames.length);
        for (String cacheName : cacheNames) {
            caches.add(new ConcurrentMapCache(cacheName));
            this.CACHE_EXPIREDMINUTES_CACHE.put(cacheName, expiredMinutes);
            this.CACHE_CLEANDATE_CACHE.put(cacheName, "");
        }
        this.setCaches(caches);
    }

    public DynamicMemoryCacheManager(Map<String, Integer> cacheName2ExpiredMinutes) {
        ArrayList<ConcurrentMapCache> caches = new ArrayList<ConcurrentMapCache>(cacheName2ExpiredMinutes.size());
        for (Map.Entry<String, Integer> cacheEntry : cacheName2ExpiredMinutes.entrySet()) {
            caches.add(new ConcurrentMapCache(cacheEntry.getKey()));
            this.CACHE_EXPIREDMINUTES_CACHE.put(cacheEntry.getKey(), cacheEntry.getValue());
            this.CACHE_CLEANDATE_CACHE.put(cacheEntry.getKey(), "");
        }
        this.setCaches(caches);
    }

    @Override
    public <T> T getCacheObj(String cacheName, Object objKey, Class<T> tClass) {
        Cache cache = this.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        if (this.isExpired(cacheName, objKey)) {
            cache.evict(objKey);
            if (log.isDebugEnabled()) {
                log.debug("\u7f13\u5b58\u5df2\u8fc7\u671f\u88ab\u6e05\u7406: {}.{}", (Object)cacheName, objKey);
            }
            return null;
        }
        return (T)cache.get(objKey, tClass);
    }

    @Override
    public void putCacheObj(String cacheName, Object objKey, Object obj) {
        super.putCacheObj(cacheName, objKey, obj);
        this.refreshCacheTimestamp(cacheName, objKey);
        this.clearOutOfDateDataIfNeeded(cacheName);
    }

    @Override
    public synchronized void clearOutOfDateData(String cacheName) {
        Cache cache = this.getCache(cacheName);
        if (cache == null) {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6cache\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316", cacheName);
        }
        ConcurrentMap cacheMap = (ConcurrentMap)cache.getNativeCache();
        if (V.isEmpty(cacheMap)) {
            log.debug("\u6682\u65e0\u7f13\u5b58\u6570\u636e: {}", (Object)cacheName);
            return;
        }
        int count = 0;
        for (Map.Entry entry : cacheMap.entrySet()) {
            if (!this.isExpired(cacheName, entry.getKey())) continue;
            cache.evict(entry.getKey());
            ++count;
            log.debug("\u6e05\u7406\u5df2\u8fc7\u671f\u7684\u7f13\u5b58: {}.{}", (Object)cacheName, entry.getKey());
        }
        log.debug("\u6e05\u7406\u5b8c\u6210\u5df2\u8fc7\u671f\u7f13\u5b58\u6570\u636e: {} \u5171 {} \u6761", (Object)cacheName, (Object)count);
    }

    public boolean isExpired(String cacheName, Object objKey) {
        ConcurrentMap timestampCache = this.CACHE_TIMESTAMP_CACHE.get(cacheName);
        if (V.isEmpty(timestampCache)) {
            return false;
        }
        Long cacheTimestamp = (Long)timestampCache.get(objKey);
        if (cacheTimestamp == null) {
            return false;
        }
        long currentTimestamp = System.currentTimeMillis();
        int expiredMinutes = this.CACHE_EXPIREDMINUTES_CACHE.get(cacheName);
        return currentTimestamp - cacheTimestamp > (long)expiredMinutes * 60000L;
    }

    private void clearOutOfDateDataIfNeeded(String cacheName) {
        boolean needed = true;
        String today = LocalDate.now().toString();
        if (this.CACHE_CLEANDATE_CACHE.containsKey(cacheName)) {
            needed = V.notEquals(today, this.CACHE_CLEANDATE_CACHE.get(cacheName));
        }
        if (needed) {
            log.debug("\u65b0\u7684\u6267\u884c\u5468\u671f\u6e05\u7406\u8fc7\u671f\u7684\u672c\u5730\u7f13\u5b58: {}", (Object)cacheName);
            this.clearOutOfDateData(cacheName);
            this.CACHE_CLEANDATE_CACHE.put(cacheName, today);
        }
    }

    private void refreshCacheTimestamp(String cacheName, Object objKey) {
        ConcurrentHashMap timestampCache = this.CACHE_TIMESTAMP_CACHE.computeIfAbsent(cacheName, k -> new ConcurrentHashMap());
        timestampCache.put(objKey, System.currentTimeMillis());
    }
}

