/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.cache;

import com.diboot.core.cache.BaseCacheManager;
import com.diboot.core.exception.InvalidUsageException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.SimpleCacheManager;

public abstract class BaseMemoryCacheManager
extends SimpleCacheManager
implements BaseCacheManager {
    private static final Logger log = LoggerFactory.getLogger(BaseMemoryCacheManager.class);

    @Override
    public <T> T getCacheObj(String cacheName, Object objKey, Class<T> tClass) {
        Object value;
        Cache cache = this.getCache(cacheName);
        Object object = value = cache != null ? cache.get(objKey, tClass) : null;
        if (log.isTraceEnabled()) {
            log.trace("\u4ece\u7f13\u5b58\u8bfb\u53d6: {}.{} = {}", new Object[]{cacheName, objKey, value});
        }
        return (T)value;
    }

    @Override
    public <T> T getCacheObj(String cacheName, Object objKey, Callable<T> initSupplier) {
        Object value;
        Cache cache = this.getCache(cacheName);
        Object object = value = cache != null ? cache.get(objKey, initSupplier) : null;
        if (log.isTraceEnabled()) {
            log.trace("\u4ece\u7f13\u5b58\u8bfb\u53d6: {}.{} = {}", new Object[]{cacheName, objKey, value});
        }
        return (T)value;
    }

    @Override
    public String getCacheString(String cacheName, Object objKey) {
        return this.getCacheObj(cacheName, objKey, String.class);
    }

    @Override
    public void putCacheObj(String cacheName, Object objKey, Object obj) {
        Cache cache = this.getCache(cacheName);
        if (cache != null) {
            cache.put(objKey, obj);
            if (log.isDebugEnabled()) {
                ConcurrentMapCache mapCache = (ConcurrentMapCache)cache;
                log.debug("\u7f13\u5b58: {} \u65b0\u589e-> {} , \u5f53\u524dsize={}", new Object[]{cacheName, objKey, mapCache.getNativeCache().size()});
            }
        } else {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6cache\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316", cacheName);
        }
    }

    @Override
    public void removeCacheObj(String cacheName, Object objKey) {
        Cache cache = this.getCache(cacheName);
        if (cache != null) {
            cache.evict(objKey);
            if (log.isDebugEnabled()) {
                ConcurrentMapCache mapCache = (ConcurrentMapCache)cache;
                log.debug("\u7f13\u5b58\u5220\u9664: {}.{} , \u5f53\u524dsize={}", new Object[]{cacheName, objKey, mapCache.getNativeCache().size()});
            }
        } else {
            throw new InvalidUsageException("\u65e0\u6cd5\u83b7\u53d6cache\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316", cacheName);
        }
    }

    @Override
    public boolean isUninitializedCache(String cacheName) {
        ConcurrentMapCache cache = (ConcurrentMapCache)this.getCache(cacheName);
        if (cache != null) {
            return cache.getNativeCache().isEmpty();
        }
        return true;
    }
}

