/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.query.dynamic;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.diboot.core.binding.QueryBuilder;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.binding.query.dynamic.AnnoJoiner;
import com.diboot.core.binding.query.dynamic.DynamicJoinQueryWrapper;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSqlProvider {
    private static final Logger log = LoggerFactory.getLogger(DynamicSqlProvider.class);
    public static final String PLACEHOLDER_COLUMN_FLAG = "__";

    public String buildSqlForList(QueryWrapper ew) {
        return this.buildDynamicSql(null, ew);
    }

    public <DTO> String buildSqlForListWithPage(Page<?> page, QueryWrapper<DTO> ew) {
        return this.buildDynamicSql(page, ew);
    }

    private <DTO> String buildDynamicSql(final Page<?> page, final QueryWrapper<DTO> ew) {
        final DynamicJoinQueryWrapper wrapper = (DynamicJoinQueryWrapper)ew;
        return new SQL(){
            {
                MergeSegments segments;
                this.SELECT_DISTINCT(DynamicSqlProvider.this.formatSqlSelect(ew.getSqlSelect(), page));
                this.FROM(wrapper.getEntityTable() + " self");
                List<AnnoJoiner> annoJoinerList = wrapper.getAnnoJoiners();
                if (V.notEmpty(annoJoinerList)) {
                    HashSet<String> tempSet = new HashSet<String>();
                    StringBuilder sb = new StringBuilder();
                    for (AnnoJoiner joiner : annoJoinerList) {
                        String joinSegment;
                        String deletedCol;
                        if (!V.notEmpty(joiner.getJoin()) || !V.notEmpty(joiner.getOnSegment())) continue;
                        if (joiner.getMiddleTable() != null) {
                            sb.setLength(0);
                            sb.append(joiner.getMiddleTable()).append(" ").append(joiner.getMiddleTableAlias()).append(" ON ").append(joiner.getMiddleTableOnSegment());
                            deletedCol = ParserCache.getDeletedColumn(joiner.getMiddleTable());
                            if (deletedCol != null && !S.containsIgnoreCase((CharSequence)joiner.getMiddleTable(), (CharSequence)(" " + deletedCol))) {
                                sb.append(" AND ").append(joiner.getMiddleTableAlias()).append(".").append(deletedCol).append(" = ").append(BaseConfig.getActiveFlagValue());
                            }
                            if (!tempSet.contains(joinSegment = sb.toString())) {
                                this.LEFT_OUTER_JOIN(joinSegment);
                                tempSet.add(joinSegment);
                            }
                        }
                        sb.setLength(0);
                        sb.append(joiner.getJoin()).append(" ").append(joiner.getAlias()).append(" ON ").append(joiner.getOnSegment());
                        deletedCol = ParserCache.getDeletedColumn(joiner.getJoin());
                        if (deletedCol != null && !S.containsIgnoreCase((CharSequence)joiner.getOnSegment(), (CharSequence)(" " + deletedCol))) {
                            sb.append(" AND ").append(joiner.getAlias()).append(".").append(deletedCol).append(" = ").append(BaseConfig.getActiveFlagValue());
                        }
                        if (tempSet.contains(joinSegment = sb.toString())) continue;
                        this.LEFT_OUTER_JOIN(joinSegment);
                        tempSet.add(joinSegment);
                    }
                    tempSet = null;
                }
                if ((segments = ew.getExpression()) != null) {
                    String normalSql = segments.getNormal().getSqlSegment();
                    if (V.notEmpty(normalSql)) {
                        this.WHERE(DynamicSqlProvider.this.formatNormalSql(normalSql));
                        isDeletedCol = ParserCache.getDeletedColumn(wrapper.getEntityTable());
                        isDeletedSection = "self." + isDeletedCol;
                        if (isDeletedCol != null && !QueryBuilder.checkHasColumn(segments.getNormal(), isDeletedSection)) {
                            this.WHERE((String)isDeletedSection + " = " + BaseConfig.getActiveFlagValue());
                        }
                        if (page != null && V.notEmpty(page.orders())) {
                            ArrayList orderByList = new ArrayList(page.orders().size());
                            page.orders().forEach(orderItem -> orderByList.add(S.format("%s %s", orderItem.getColumn(), orderItem.isAsc() ? "ASC" : "DESC")));
                            if (orderByList.size() > 0) {
                                String orderBySql = S.join(orderByList);
                                this.ORDER_BY(orderBySql);
                            }
                        }
                    } else if (V.notEmpty(annoJoinerList)) {
                        isDeletedCol = ParserCache.getDeletedColumn(wrapper.getEntityTable());
                        isDeletedSection = "self." + isDeletedCol;
                        if (isDeletedCol != null && !QueryBuilder.checkHasColumn(segments.getNormal(), isDeletedSection)) {
                            this.WHERE(isDeletedSection + " = " + BaseConfig.getActiveFlagValue());
                        }
                    }
                }
            }
        }.toString();
    }

    private String formatSqlSelect(String sqlSelect, Page<?> page) {
        HashSet<CallSite> columnSets = null;
        StringBuilder sb = new StringBuilder();
        if (V.isEmpty(sqlSelect)) {
            sb.append("self.*");
        } else {
            String[] columns = S.split(sqlSelect);
            for (int i = 0; i < columns.length; ++i) {
                String column = S.removeDuplicateBlank(columns[i]).trim();
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("self.").append(column);
                if (columnSets == null) {
                    columnSets = new HashSet<CallSite>();
                }
                columnSets.add((CallSite)((Object)("self." + column)));
            }
        }
        if (page != null && page.orders() != null) {
            for (OrderItem orderItem : page.orders()) {
                if ((!V.isEmpty(sqlSelect) || S.startsWith((CharSequence)orderItem.getColumn(), (CharSequence)"self.")) && (columnSets == null || columnSets.contains(orderItem.getColumn()))) continue;
                sb.append(",").append(orderItem.getColumn()).append(" AS ").append(S.replace((String)orderItem.getColumn(), (String)".", (String)"_")).append(PLACEHOLDER_COLUMN_FLAG);
            }
        }
        return sb.toString();
    }

    private String formatNormalSql(String normalSql) {
        if (normalSql.startsWith("(") && normalSql.endsWith(")")) {
            return S.substring((String)normalSql, (int)1, (int)(normalSql.length() - 1));
        }
        return normalSql;
    }
}

