/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.query.dynamic;

import com.baomidou.mybatisplus.annotation.TableField;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.binding.query.BindQuery;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.binding.query.dynamic.JoinConditionManager;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.lang.model.type.NullType;

public class AnnoJoiner
implements Serializable {
    private static final long serialVersionUID = 5998965277333389063L;
    private String key;
    private Comparison comparison;
    private String fieldName;
    private String columnName;
    private String condition;
    private String join;
    private String alias;
    private String onSegment;
    private String middleTable;
    private String middleTableOnSegment;

    public AnnoJoiner(Field field, BindQuery query) {
        this.key = field.getName() + query;
        this.fieldName = field.getName();
        this.comparison = query.comparison();
        if (V.notEmpty(query.column())) {
            this.columnName = query.column();
        } else if (field.isAnnotationPresent(TableField.class)) {
            this.columnName = field.getAnnotation(TableField.class).value();
        }
        if (V.isEmpty(this.columnName)) {
            this.columnName = S.toSnakeCase(field.getName());
        }
        if (!NullType.class.equals(query.entity())) {
            this.join = ParserCache.getEntityTableName(query.entity());
        }
        if (V.notEmpty(query.condition())) {
            this.condition = query.condition();
        }
    }

    public String getMiddleTableAlias() {
        if (this.middleTable != null && this.alias != null) {
            return this.alias + "m";
        }
        return null;
    }

    public void parse() {
        JoinConditionManager.parseJoinCondition(this);
    }

    public String getKey() {
        return this.key;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getJoin() {
        return this.join;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getOnSegment() {
        return this.onSegment;
    }

    public String getMiddleTable() {
        return this.middleTable;
    }

    public String getMiddleTableOnSegment() {
        return this.middleTableOnSegment;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setJoin(String join) {
        this.join = join;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setOnSegment(String onSegment) {
        this.onSegment = onSegment;
    }

    public void setMiddleTable(String middleTable) {
        this.middleTable = middleTable;
    }

    public void setMiddleTableOnSegment(String middleTableOnSegment) {
        this.middleTableOnSegment = middleTableOnSegment;
    }
}

