/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.diboot.core.binding.annotation.BindCount;
import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.binding.annotation.BindEntity;
import com.diboot.core.binding.annotation.BindEntityList;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.binding.annotation.BindFieldList;
import com.diboot.core.binding.annotation.BindI18n;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.parser.BindAnnotationGroup;
import com.diboot.core.binding.parser.EntityInfoCache;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.binding.query.BindQuery;
import com.diboot.core.binding.query.dynamic.AnnoJoiner;
import com.diboot.core.data.annotation.DataMask;
import com.diboot.core.data.protect.DefaultEncryptTypeHandler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class ParserCache {
    private static final Logger log = LoggerFactory.getLogger(ParserCache.class);
    private static final Map<Class<?>, BindAnnotationGroup> allVoBindAnnotationCacheMap = new ConcurrentHashMap();
    private static final Map<String, List<AnnoJoiner>> dtoClassBindQueryCacheMap = new ConcurrentHashMap<String, List<AnnoJoiner>>();
    private static final Map<String, List<String>> ENCRYPT_FIELD_MAP = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, List<String>> DATA_MASK_FIELD_MAP = new ConcurrentHashMap<String, List<String>>();
    private static final Set<Class<?>> BIND_ANNOTATION_SET = new HashSet<Class>(Arrays.asList(BindDict.class, BindField.class, BindFieldList.class, BindEntity.class, BindEntityList.class, BindCount.class, BindI18n.class));

    public static BindAnnotationGroup getBindAnnotationGroup(Class<?> voClass) {
        return allVoBindAnnotationCacheMap.computeIfAbsent(voClass, k -> {
            BindAnnotationGroup group = new BindAnnotationGroup();
            List<Field> fields = BeanUtils.extractAllFields(voClass, true);
            if (V.notEmpty(fields)) {
                for (Field field : fields) {
                    Type genericType;
                    Object[] annotations = field.getDeclaredAnnotations();
                    if (V.isEmpty(annotations)) continue;
                    String fieldName = field.getName();
                    Class setterObjClazz = field.getType();
                    if ((setterObjClazz.equals(List.class) || setterObjClazz.equals(Collection.class)) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericType;
                        setterObjClazz = (Class)pt.getActualTypeArguments()[0];
                    }
                    for (Object annotation : annotations) {
                        if (!BIND_ANNOTATION_SET.contains(annotation.annotationType())) continue;
                        group.addBindAnnotation(fieldName, setterObjClazz, (Annotation)annotation);
                    }
                }
            }
            return group;
        });
    }

    public static String getDeletedColumn(String table) {
        PropInfo propInfo = BindingCacheManager.getPropInfoByTable(table);
        if (propInfo != null) {
            return propInfo.getDeletedColumn();
        }
        log.debug("\u672a\u80fd\u8bc6\u522b\u5230\u903b\u8f91\u5220\u9664\u5b57\u6bb5, table={}", (Object)table);
        return null;
    }

    public static String getEntityTableName(Class<?> entityClass) {
        EntityInfoCache entityInfoCache = BindingCacheManager.getEntityInfoByClass(entityClass);
        if (entityInfoCache != null) {
            return entityInfoCache.getTableName();
        }
        TableName tableNameAnno = (TableName)AnnotationUtils.findAnnotation(entityClass, TableName.class);
        if (tableNameAnno != null && V.notEmpty(tableNameAnno.value())) {
            return tableNameAnno.value();
        }
        return S.toSnakeCase(entityClass.getSimpleName());
    }

    @Deprecated
    public static Class<?> getEntityClassByClassName(String className) {
        return BindingCacheManager.getEntityClassBySimpleName(className);
    }

    public static BaseMapper getMapperInstance(Class<?> entityClass) {
        BaseMapper mapper = BindingCacheManager.getMapperByClass(entityClass);
        if (mapper == null) {
            throw new InvalidUsageException("\u672a\u627e\u5230 " + entityClass.getName() + " \u7684Mapper\u5b9a\u4e49\uff01", new Object[0]);
        }
        return mapper;
    }

    public static <DTO> boolean hasJoinTable(DTO dto, Collection<String> fieldNameSet) {
        List<AnnoJoiner> annoList = ParserCache.getBindQueryAnnos(dto.getClass());
        if (V.notEmpty(annoList)) {
            for (AnnoJoiner anno : annoList) {
                if (!V.notEmpty(anno.getJoin()) || !V.contains(fieldNameSet, anno.getFieldName())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<AnnoJoiner> getBindQueryAnnos(Class<?> dtoClass) {
        String dtoClassName = dtoClass.getName();
        if (dtoClassBindQueryCacheMap.containsKey(dtoClassName)) {
            return dtoClassBindQueryCacheMap.get(dtoClassName);
        }
        ArrayList<AnnoJoiner> annos = new ArrayList<AnnoJoiner>();
        AtomicInteger index = new AtomicInteger(1);
        HashMap joinOn2Alias = new HashMap(8);
        BiConsumer<Field, BindQuery> buildAnnoJoiner = (field, query) -> {
            AnnoJoiner annoJoiner = new AnnoJoiner((Field)field, (BindQuery)query);
            if (V.notEmpty(annoJoiner.getJoin())) {
                String key = annoJoiner.getJoin() + ":" + annoJoiner.getCondition();
                Object alias = (String)joinOn2Alias.get(key);
                if (alias == null) {
                    alias = "r" + index.getAndIncrement();
                    annoJoiner.setAlias((String)alias);
                    joinOn2Alias.put(key, alias);
                } else {
                    annoJoiner.setAlias((String)alias);
                }
                annoJoiner.parse();
            }
            annos.add(annoJoiner);
        };
        for (Field field2 : BeanUtils.extractFields(dtoClass, BindQuery.class)) {
            BindQuery query2 = field2.getAnnotation(BindQuery.class);
            if (query2.ignore()) continue;
            buildAnnoJoiner.accept(field2, query2);
        }
        for (Field field2 : BeanUtils.extractFields(dtoClass, BindQuery.List.class)) {
            BindQuery.List queryList = field2.getAnnotation(BindQuery.List.class);
            for (BindQuery bindQuery : queryList.value()) {
                buildAnnoJoiner.accept(field2, bindQuery);
            }
        }
        dtoClassBindQueryCacheMap.put(dtoClassName, annos);
        return annos;
    }

    public static List<AnnoJoiner> getAnnoJoiners(Class<?> dtoClass, Collection<String> fieldNames) {
        List<AnnoJoiner> annoList = ParserCache.getBindQueryAnnos(dtoClass);
        if (fieldNames == null) {
            return annoList;
        }
        if (V.notEmpty(annoList)) {
            ArrayList<AnnoJoiner> matchedAnnoList = new ArrayList<AnnoJoiner>();
            for (AnnoJoiner anno : annoList) {
                if (!fieldNames.contains(anno.getFieldName())) continue;
                matchedAnnoList.add(anno);
            }
            return matchedAnnoList;
        }
        return Collections.emptyList();
    }

    @NonNull
    public static List<String> getProtectFieldList(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ENCRYPT_FIELD_MAP.computeIfAbsent(clazz.getName(), k -> {
            ArrayList protectFieldList = new ArrayList(4);
            for (Field field : BeanUtils.extractFields(clazz, TableField.class)) {
                Class typeHandler;
                TableField tableField;
                if (!field.getType().isAssignableFrom(String.class) || (tableField = field.getAnnotation(TableField.class)).typeHandler() == null || !(typeHandler = tableField.typeHandler()).isAssignableFrom(DefaultEncryptTypeHandler.class)) continue;
                protectFieldList.add(field.getName());
                log.debug("\u76d1\u6d4b\u5230\u52a0\u5bc6\u4fdd\u62a4\u5b57\u6bb5\uff1a{}.{}", (Object)clazz.getSimpleName(), (Object)field.getName());
            }
            return protectFieldList.isEmpty() ? Collections.emptyList() : protectFieldList;
        });
    }

    @NonNull
    public static List<String> getDataMaskFieldList(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return DATA_MASK_FIELD_MAP.computeIfAbsent(clazz.getName(), k -> {
            ArrayList maskFieldList = new ArrayList(4);
            for (Field field : BeanUtils.extractFields(clazz, DataMask.class)) {
                if (!field.getType().isAssignableFrom(String.class)) {
                    throw new InvalidUsageException("`@DataMask` \u4ec5\u652f\u6301 String \u7c7b\u578b\u5b57\u6bb5\u3002", new Object[0]);
                }
                maskFieldList.add(field.getName());
            }
            return maskFieldList.isEmpty() ? Collections.emptyList() : maskFieldList;
        });
    }
}

