/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.binding.parser.EntityInfoCache;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.S;
import com.diboot.core.util.SqlExecutor;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddleTable {
    private static final Logger log = LoggerFactory.getLogger(MiddleTable.class);
    private String table;
    private Map<String, String> trunkObjColMapping;
    private Map<String, String> branchObjColMapping;
    private List<String> additionalConditions;

    public MiddleTable(String table) {
        this.table = table;
    }

    public MiddleTable connectTrunkObj(String middleTableCol, String trunkObjCol) {
        if (this.trunkObjColMapping == null) {
            this.trunkObjColMapping = new LinkedHashMap<String, String>(8);
        }
        this.trunkObjColMapping.put(trunkObjCol, middleTableCol);
        return this;
    }

    public MiddleTable connectBranchObj(String middleTableCol, String branchObjCol) {
        if (this.branchObjColMapping == null) {
            this.branchObjColMapping = new LinkedHashMap<String, String>(8);
        } else if (this.branchObjColMapping.size() >= 1) {
            throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
        }
        this.branchObjColMapping.put(middleTableCol, branchObjCol);
        return this;
    }

    public MiddleTable addAdditionalCondition(String additionalCondition) {
        if (this.additionalConditions == null) {
            this.additionalConditions = new ArrayList<String>();
        }
        this.additionalConditions.add(additionalCondition);
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getTrunkObjColMapping() {
        return this.trunkObjColMapping;
    }

    public Map<String, String> getBranchObjColMapping() {
        return this.branchObjColMapping;
    }

    public Map<String, Object> executeOneToOneQuery(Map<String, List> trunkObjCol2ValuesMap) {
        if (V.isEmpty(trunkObjCol2ValuesMap)) {
            log.warn("\u4e0d\u5408\u7406\u7684\u4e2d\u95f4\u8868\u67e5\u8be2\uff1a\u65e0\u8fc7\u6ee4\u6761\u4ef6\uff01");
            return Collections.emptyMap();
        }
        EntityInfoCache linkage = BindingCacheManager.getEntityInfoByTable(this.table);
        if (linkage != null) {
            List resultSetMapList = this.queryByMapper(linkage, trunkObjCol2ValuesMap);
            return ResultAssembler.convertToOneToOneResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        ArrayList paramValueList = new ArrayList();
        String sql = this.toSQL(trunkObjCol2ValuesMap, paramValueList);
        try {
            List resultSetMapList = SqlExecutor.executeQuery(sql, paramValueList.toArray());
            return ResultAssembler.convertToOneToOneResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        catch (Exception e) {
            log.error("\u4e2d\u95f4\u8868\u67e5\u8be2\u5f02\u5e38: " + sql, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public Map<String, Long> executeOneToManyCountQuery(Map<String, List> trunkObjCol2ValuesMap) {
        if (V.isEmpty(trunkObjCol2ValuesMap)) {
            throw new InvalidUsageException("\u4e0d\u5408\u7406\u7684\u4e2d\u95f4\u8868\u67e5\u8be2\uff1a\u65e0\u8fc7\u6ee4\u6761\u4ef6\uff01", new Object[0]);
        }
        EntityInfoCache linkage = BindingCacheManager.getEntityInfoByTable(this.table);
        if (linkage != null) {
            List resultSetMapList = this.queryByMapper(linkage, trunkObjCol2ValuesMap, true);
            return ResultAssembler.convertToOneToManyCountResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        ArrayList paramValueList = new ArrayList();
        String sql = this.toSQL(trunkObjCol2ValuesMap, paramValueList, true);
        try {
            List resultSetMapList = SqlExecutor.executeQuery(sql, paramValueList.toArray());
            return ResultAssembler.convertToOneToManyCountResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        catch (Exception e) {
            log.error("\u4e2d\u95f4\u8868\u67e5\u8be2\u5f02\u5e38: " + sql, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public Map<String, List> executeOneToManyQuery(Map<String, List> trunkObjCol2ValuesMap) {
        if (V.isEmpty(trunkObjCol2ValuesMap)) {
            throw new InvalidUsageException("\u4e0d\u5408\u7406\u7684\u4e2d\u95f4\u8868\u67e5\u8be2\uff1a\u65e0\u8fc7\u6ee4\u6761\u4ef6\uff01", new Object[0]);
        }
        EntityInfoCache linkage = BindingCacheManager.getEntityInfoByTable(this.table);
        if (linkage != null) {
            List resultSetMapList = this.queryByMapper(linkage, trunkObjCol2ValuesMap);
            return ResultAssembler.convertToOneToManyResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        ArrayList paramValueList = new ArrayList();
        String sql = this.toSQL(trunkObjCol2ValuesMap, paramValueList);
        try {
            List resultSetMapList = SqlExecutor.executeQuery(sql, paramValueList.toArray());
            return ResultAssembler.convertToOneToManyResult(resultSetMapList, this.trunkObjColMapping, this.branchObjColMapping);
        }
        catch (Exception e) {
            log.error("\u4e2d\u95f4\u8868\u67e5\u8be2\u5f02\u5e38: " + sql, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private List<Map<String, Object>> queryByMapper(EntityInfoCache linkage, Map<String, List> trunkObjCol2ValuesMap) {
        return this.queryByMapper(linkage, trunkObjCol2ValuesMap, false);
    }

    private List<Map<String, Object>> queryByMapper(EntityInfoCache linkage, Map<String, List> trunkObjCol2ValuesMap, boolean isCount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(linkage.getEntityClass());
        if (isCount) {
            queryWrapper.select(this.getSelectColumns4Count(true));
        } else {
            queryWrapper.select((Object[])this.getSelectColumns());
        }
        for (Map.Entry<String, List> entry : trunkObjCol2ValuesMap.entrySet()) {
            String column = entry.getKey();
            if (column == null || !V.notEmpty(entry.getValue())) continue;
            queryWrapper.in((Object)column, (Collection)entry.getValue());
        }
        if (this.additionalConditions != null) {
            for (String condition : this.additionalConditions) {
                queryWrapper.apply(condition, new Object[0]);
            }
        }
        if (isCount) {
            queryWrapper.groupBy(this.getSelectColumns4Count(false));
        }
        if (queryWrapper.isEmptyOfNormal()) {
            return Collections.emptyList();
        }
        BaseMapper mapper = linkage.getBaseMapper();
        List resultSetMapList = mapper.selectMaps((Wrapper)queryWrapper);
        return resultSetMapList;
    }

    private String toSQL(Map<String, List> trunkObjCol2ValuesMap, List paramValueList) {
        return this.toSQL(trunkObjCol2ValuesMap, paramValueList, false);
    }

    private String toSQL(final Map<String, List> trunkObjCol2ValuesMap, final List paramValueList, final boolean isCount) {
        if (V.isEmpty(trunkObjCol2ValuesMap)) {
            return null;
        }
        return new SQL(){
            {
                String deletedCol;
                this.SELECT(isCount ? S.join(MiddleTable.this.getSelectColumns4Count(true)) : S.join(MiddleTable.this.getSelectColumns()));
                this.FROM(MiddleTable.this.table);
                for (Map.Entry entry : trunkObjCol2ValuesMap.entrySet()) {
                    String column = (String)entry.getKey();
                    if (column == null || !V.notEmpty((Collection)entry.getValue())) continue;
                    List values = ((List)entry.getValue()).stream().distinct().collect(Collectors.toList());
                    String params = S.repeat((String)"?", (String)",", (int)values.size());
                    this.WHERE(column + " IN (" + params + ")");
                    paramValueList.addAll(values);
                }
                if (isCount) {
                    this.GROUP_BY(S.toStringArray(MiddleTable.this.getSelectColumns4Count(false)));
                }
                boolean appendDeleteFlag = true;
                if (MiddleTable.this.additionalConditions != null) {
                    for (String condition : MiddleTable.this.additionalConditions) {
                        this.WHERE(condition);
                        if (!S.containsIgnoreCase((CharSequence)condition, (CharSequence)"is_deleted")) continue;
                        appendDeleteFlag = false;
                    }
                }
                if (appendDeleteFlag && (deletedCol = ParserCache.getDeletedColumn(MiddleTable.this.table)) != null) {
                    this.WHERE(deletedCol + " = " + BaseConfig.getActiveFlagValue());
                }
            }
        }.toString();
    }

    private String[] getSelectColumns() {
        ArrayList<String> columns = new ArrayList<String>(8);
        if (V.notEmpty(this.trunkObjColMapping)) {
            for (Map.Entry<String, String> entry : this.trunkObjColMapping.entrySet()) {
                columns.add(entry.getValue());
            }
        }
        if (V.notEmpty(this.branchObjColMapping)) {
            for (Map.Entry<String, String> entry : this.branchObjColMapping.entrySet()) {
                columns.add(entry.getKey());
            }
        }
        return S.toStringArray(columns);
    }

    private List<String> getSelectColumns4Count(boolean appendCount) {
        ArrayList<String> columns = new ArrayList<String>(8);
        if (V.notEmpty(this.trunkObjColMapping)) {
            for (Map.Entry<String, String> entry : this.trunkObjColMapping.entrySet()) {
                columns.add(entry.getValue());
            }
        }
        if (appendCount) {
            columns.add("count(*) AS _cnt");
        }
        return columns;
    }
}

