/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.diboot.core.binding.binder.BaseBinder;
import com.diboot.core.binding.parser.BaseConditionManager;
import com.diboot.core.binding.parser.MiddleTable;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionManager
extends BaseConditionManager {
    private static final Logger log = LoggerFactory.getLogger(ConditionManager.class);

    public static <T> void parseConditions(String condition, BaseBinder<T> binder) {
        List<Expression> expressionList = ConditionManager.getExpressionList(condition);
        if (V.isEmpty(expressionList)) {
            log.warn("\u65e0\u6cd5\u89e3\u6790\u6ce8\u89e3\u6761\u4ef6: {} ", (Object)condition);
            return;
        }
        String tableName = ConditionManager.extractMiddleTableName(expressionList);
        if (tableName != null) {
            List<Expression> additionalExpress = ConditionManager.parseMiddleTable(binder, expressionList, tableName);
            if (V.notEmpty(additionalExpress)) {
                ConditionManager.parseDirectRelation(binder, additionalExpress);
            }
        } else {
            ConditionManager.parseDirectRelation(binder, expressionList);
        }
    }

    private static <T> void parseDirectRelation(BaseBinder<T> binder, List<Expression> expressionList) {
        for (Expression operator : expressionList) {
            Object consValue;
            String annoColumn;
            EqualsTo express;
            if (operator instanceof EqualsTo) {
                express = (EqualsTo)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    String entityColumn = ConditionManager.removeLeftAlias(express.getRightExpression().toString());
                    if (ConditionManager.isCurrentObjColumn(express.getRightExpression().toString()) && !ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                        binder.joinOn(entityColumn, annoColumn);
                        continue;
                    }
                    binder.joinOn(annoColumn, entityColumn);
                    continue;
                }
                if (ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                    consValue = ConditionManager.extractConsValue(express.getRightExpression());
                    binder.joinOnFieldComparison(annoColumn, Comparison.EQ, consValue);
                    continue;
                }
                binder.andEQ(annoColumn, express.getRightExpression().toString());
                binder.additionalCondition(annoColumn + " = " + express.getRightExpression().toString());
                continue;
            }
            if (operator instanceof NotEqualsTo) {
                express = (NotEqualsTo)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    binder.andApply(annoColumn + " != " + express.getRightExpression().toString());
                } else if (ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                    consValue = ConditionManager.extractConsValue(express.getRightExpression());
                    binder.joinOnFieldComparison(annoColumn, Comparison.NOT_EQ, consValue);
                } else {
                    binder.andNE(annoColumn, express.getRightExpression().toString());
                }
            } else if (operator instanceof GreaterThan) {
                express = (GreaterThan)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    binder.andApply(annoColumn + " > " + express.getRightExpression().toString());
                } else {
                    binder.andGT(annoColumn, express.getRightExpression().toString());
                }
            } else if (operator instanceof GreaterThanEquals) {
                express = (GreaterThanEquals)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    binder.andApply(annoColumn + " >= " + express.getRightExpression().toString());
                } else {
                    binder.andGE(annoColumn, express.getRightExpression().toString());
                }
            } else if (operator instanceof MinorThan) {
                express = (MinorThan)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    binder.andApply(annoColumn + " < " + express.getRightExpression().toString());
                } else {
                    binder.andLT(annoColumn, express.getRightExpression().toString());
                }
            } else if (operator instanceof MinorThanEquals) {
                express = (MinorThanEquals)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (express.getRightExpression() instanceof Column) {
                    binder.andApply(annoColumn + " <= " + express.getRightExpression().toString());
                } else {
                    binder.andLE(annoColumn, express.getRightExpression().toString());
                }
            } else if (operator instanceof IsNullExpression) {
                express = (IsNullExpression)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (!express.isNot()) {
                    binder.andIsNull(annoColumn);
                } else {
                    binder.andIsNotNull(annoColumn);
                }
            } else if (operator instanceof InExpression) {
                express = (InExpression)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (!express.isNot()) {
                    if (ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                        consValues = ConditionManager.extractConsValues(express.getRightExpression());
                        binder.joinOnFieldComparison(annoColumn, Comparison.IN, consValues);
                    } else {
                        binder.andApply(annoColumn + " IN " + express.getRightExpression().toString());
                    }
                } else if (ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                    consValues = ConditionManager.extractConsValues(express.getRightExpression());
                    binder.joinOnFieldComparison(annoColumn, Comparison.NOT_IN, consValues);
                } else {
                    binder.andApply(annoColumn + " NOT IN " + express.getRightExpression().toString());
                }
            } else if (operator instanceof Between) {
                express = (Between)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                if (!express.isNot()) {
                    binder.andBetween(annoColumn, express.getBetweenExpressionStart().toString(), express.getBetweenExpressionEnd().toString());
                } else {
                    binder.andNotBetween(annoColumn, express.getBetweenExpressionStart().toString(), express.getBetweenExpressionEnd().toString());
                }
            } else if (operator instanceof LikeExpression) {
                express = (LikeExpression)operator;
                annoColumn = ConditionManager.removeLeftAlias(express.getLeftExpression().toString());
                String value = express.getRightExpression().toString();
                if (!express.isNot()) {
                    if (ConditionManager.isCurrentObjColumn(express.getLeftExpression().toString())) {
                        StringValue valueObj = (StringValue)express.getRightExpression();
                        String consValue2 = S.replace((String)valueObj.getValue(), (String)"%", (String)"");
                        binder.joinOnFieldComparison(annoColumn, Comparison.CONTAINS, consValue2);
                    } else {
                        binder.andLike(annoColumn, value);
                    }
                } else {
                    binder.andNotLike(annoColumn, value);
                }
            } else {
                String warnMsg = "\u4e0d\u652f\u6301\u7684\u6761\u4ef6: " + operator.toString();
                log.warn(warnMsg);
                throw new InvalidUsageException(warnMsg, new Object[0]);
            }
            binder.additionalCondition(operator.toString().replaceAll("^\\w+\\.", ""));
        }
    }

    private static <T> List<Expression> parseMiddleTable(BaseBinder<T> binder, List<Expression> expressionList, String tableName) {
        if (expressionList.size() <= 1) {
            return expressionList;
        }
        ArrayList<Expression> additionalExpressions = new ArrayList<Expression>();
        MiddleTable middleTable = new MiddleTable(tableName);
        String annoObjectForeignKey = null;
        String referencedEntityPrimaryKey = null;
        for (Expression operator : expressionList) {
            if (operator instanceof EqualsTo) {
                EqualsTo express = (EqualsTo)operator;
                if (express.getLeftExpression() instanceof Column && express.getRightExpression() instanceof Column) {
                    String middleTableCol;
                    String leftColumn = express.getLeftExpression().toString();
                    String rightColumn = express.getRightExpression().toString();
                    if (rightColumn.startsWith(tableName + ".")) {
                        String leftHandColumn = ConditionManager.removeLeftAlias(leftColumn);
                        middleTableCol = ConditionManager.removeLeftAlias(rightColumn);
                        if (ConditionManager.isCurrentObjColumn(leftColumn)) {
                            annoObjectForeignKey = leftHandColumn;
                            middleTable.connectTrunkObj(middleTableCol, leftHandColumn);
                        } else {
                            referencedEntityPrimaryKey = leftHandColumn;
                            middleTable.connectBranchObj(middleTableCol, leftHandColumn);
                        }
                        binder.joinOn(annoObjectForeignKey, referencedEntityPrimaryKey);
                        continue;
                    }
                    if (leftColumn.startsWith(tableName + ".")) {
                        String rightHandColumn = ConditionManager.removeLeftAlias(rightColumn);
                        middleTableCol = ConditionManager.removeLeftAlias(leftColumn);
                        if (ConditionManager.isCurrentObjColumn(rightColumn)) {
                            annoObjectForeignKey = rightHandColumn;
                            middleTable.connectTrunkObj(middleTableCol, rightHandColumn);
                        } else {
                            referencedEntityPrimaryKey = rightHandColumn;
                            middleTable.connectBranchObj(middleTableCol, rightHandColumn);
                        }
                        binder.joinOn(annoObjectForeignKey, referencedEntityPrimaryKey);
                        continue;
                    }
                    additionalExpressions.add((Expression)express);
                    continue;
                }
                String leftExpression = express.getLeftExpression().toString();
                if (leftExpression == null) continue;
                if (leftExpression.startsWith(tableName + ".")) {
                    middleTable.addAdditionalCondition(ConditionManager.removeLeftAlias(operator.toString()));
                    continue;
                }
                additionalExpressions.add((Expression)express);
                continue;
            }
            String leftExpression = null;
            if (operator instanceof NotEqualsTo) {
                express = (NotEqualsTo)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof GreaterThan) {
                express = (GreaterThan)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof GreaterThanEquals) {
                express = (GreaterThanEquals)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof MinorThan) {
                express = (MinorThan)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof MinorThanEquals) {
                express = (MinorThanEquals)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof IsNullExpression) {
                express = (IsNullExpression)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof InExpression) {
                express = (InExpression)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof Between) {
                express = (Between)operator;
                leftExpression = express.getLeftExpression().toString();
            } else if (operator instanceof LikeExpression) {
                express = (LikeExpression)operator;
                leftExpression = express.getLeftExpression().toString();
            }
            if (leftExpression == null) continue;
            if (leftExpression.startsWith(tableName + ".")) {
                middleTable.addAdditionalCondition(ConditionManager.removeLeftAlias(operator.toString()));
                continue;
            }
            additionalExpressions.add(operator);
        }
        binder.withMiddleTable(middleTable);
        return additionalExpressions;
    }

    private static String removeLeftAlias(String annoColumn) {
        if (annoColumn.contains(".")) {
            annoColumn = S.substringAfter((String)annoColumn, (String)".");
        }
        return annoColumn;
    }

    private static Object extractConsValue(Expression expression) {
        Object consValue;
        if (expression instanceof StringValue) {
            consValue = ((StringValue)expression).getValue();
        } else if (expression instanceof LongValue) {
            consValue = ((LongValue)expression).getValue();
        } else {
            String warnMsg = "\u4e0d\u652f\u6301\u7684\u9644\u52a0\u6761\u4ef6\u7c7b\u578b: " + expression.toString();
            log.warn(warnMsg);
            throw new InvalidUsageException(warnMsg, new Object[0]);
        }
        return consValue;
    }

    private static List<Object> extractConsValues(Expression itemsList) {
        if (itemsList instanceof ExpressionList) {
            List expressions = ((ExpressionList)itemsList).getExpressions();
            ArrayList<Object> list = new ArrayList<Object>();
            for (Expression expression : expressions) {
                list.add(ConditionManager.extractConsValue(expression));
            }
            return list;
        }
        log.warn("\u4e0d\u652f\u6301\u7684\u9644\u52a0\u6761\u4ef6\u5199\u6cd5: {}", (Object)itemsList.toString());
        return Collections.emptyList();
    }
}

