/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.diboot.core.binding.annotation.BindCount;
import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.binding.annotation.BindEntity;
import com.diboot.core.binding.annotation.BindEntityList;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.binding.annotation.BindFieldList;
import com.diboot.core.binding.annotation.BindI18n;
import com.diboot.core.binding.parser.FieldAnnotation;
import com.diboot.core.util.V;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindAnnotationGroup {
    private static final Logger log = LoggerFactory.getLogger(BindAnnotationGroup.class);
    private List<FieldAnnotation> bindDictAnnotations;
    private Map<String, List<FieldAnnotation>> bindFieldGroupMap;
    private List<FieldAnnotation> bindEntityAnnotations;
    private List<FieldAnnotation> bindEntityListAnnotations;
    private Map<String, List<FieldAnnotation>> bindFieldListGroupMap;
    private List<FieldAnnotation> bindCountAnnotations;
    private List<FieldAnnotation> bindI18nAnnotations;
    private List<FieldAnnotation> deepBindEntityAnnotations;
    private List<FieldAnnotation> deepBindEntityListAnnotations;
    private boolean requireSequential = false;

    public void addBindAnnotation(String fieldName, Class<?> fieldClass, Annotation annotation) {
        FieldAnnotation fieldAnnotation = new FieldAnnotation(fieldName, fieldClass, annotation);
        if (annotation instanceof BindDict) {
            if (this.bindDictAnnotations == null) {
                this.bindDictAnnotations = new ArrayList<FieldAnnotation>(4);
            }
            this.bindDictAnnotations.add(fieldAnnotation);
            if (!this.requireSequential && this.bindFieldGroupMap != null) {
                this.requireSequential = this.bindFieldGroupMap.values().stream().anyMatch(list -> list.stream().anyMatch(item -> item.getFieldName().equals(fieldName) && item.getFieldClass().equals(fieldClass)));
            }
            return;
        }
        Object key = null;
        try {
            if (annotation instanceof BindField) {
                bindField = (BindField)annotation;
                key = bindField.entity().getName() + ":" + bindField.condition();
            } else if (annotation instanceof BindFieldList) {
                bindField = (BindFieldList)annotation;
                key = bindField.entity().getName() + ":" + bindField.condition() + ":" + bindField.orderBy();
            } else if (annotation instanceof BindCount) {
                BindCount bindCount = (BindCount)annotation;
                key = bindCount.entity().getName() + ":" + bindCount.condition();
            } else if (annotation instanceof BindEntity) {
                bindEntity = (BindEntity)annotation;
                key = bindEntity.entity().getName();
            } else if (annotation instanceof BindEntityList) {
                bindEntity = (BindEntityList)annotation;
                key = bindEntity.entity().getName();
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u7ed1\u5b9a\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return;
        }
        if (annotation instanceof BindField) {
            if (this.bindFieldGroupMap == null) {
                this.bindFieldGroupMap = new HashMap<String, List<FieldAnnotation>>(4);
            }
            list = this.bindFieldGroupMap.computeIfAbsent((String)key, k -> new ArrayList(4));
            list.add(fieldAnnotation);
            if (!this.requireSequential && this.bindDictAnnotations != null) {
                this.requireSequential = this.bindDictAnnotations.stream().anyMatch(item -> item.getFieldName().equals(fieldName) && item.getFieldClass().equals(fieldClass));
            }
        } else if (annotation instanceof BindEntity) {
            if (this.bindEntityAnnotations == null) {
                this.bindEntityAnnotations = new ArrayList<FieldAnnotation>(4);
            }
            this.bindEntityAnnotations.add(fieldAnnotation);
            if (((BindEntity)annotation).deepBind()) {
                if (this.deepBindEntityAnnotations == null) {
                    this.deepBindEntityAnnotations = new ArrayList<FieldAnnotation>(4);
                }
                this.deepBindEntityAnnotations.add(fieldAnnotation);
            }
        } else if (annotation instanceof BindEntityList) {
            if (this.bindEntityListAnnotations == null) {
                this.bindEntityListAnnotations = new ArrayList<FieldAnnotation>(4);
            }
            this.bindEntityListAnnotations.add(fieldAnnotation);
            if (((BindEntityList)annotation).deepBind()) {
                if (this.deepBindEntityListAnnotations == null) {
                    this.deepBindEntityListAnnotations = new ArrayList<FieldAnnotation>(4);
                }
                this.deepBindEntityListAnnotations.add(fieldAnnotation);
            }
        } else if (annotation instanceof BindFieldList) {
            if (this.bindFieldListGroupMap == null) {
                this.bindFieldListGroupMap = new HashMap<String, List<FieldAnnotation>>(4);
            }
            list = this.bindFieldListGroupMap.computeIfAbsent((String)key, k -> new ArrayList(4));
            list.add(fieldAnnotation);
        } else if (annotation instanceof BindCount) {
            if (this.bindCountAnnotations == null) {
                this.bindCountAnnotations = new ArrayList<FieldAnnotation>(4);
            }
            this.bindCountAnnotations.add(fieldAnnotation);
        } else if (annotation instanceof BindI18n) {
            if (this.bindI18nAnnotations == null) {
                this.bindI18nAnnotations = new ArrayList<FieldAnnotation>(4);
            }
            this.bindI18nAnnotations.add(fieldAnnotation);
        }
    }

    public List<FieldAnnotation> getBindDictAnnotations() {
        return this.bindDictAnnotations;
    }

    public List<FieldAnnotation> getBindEntityAnnotations() {
        return this.bindEntityAnnotations;
    }

    public List<FieldAnnotation> getBindEntityListAnnotations() {
        return this.bindEntityListAnnotations;
    }

    public Map<String, List<FieldAnnotation>> getBindFieldGroupMap() {
        return this.bindFieldGroupMap;
    }

    public Map<String, List<FieldAnnotation>> getBindFieldListGroupMap() {
        return this.bindFieldListGroupMap;
    }

    public List<FieldAnnotation> getBindCountAnnotations() {
        return this.bindCountAnnotations;
    }

    public List<FieldAnnotation> getBindI18nAnnotations() {
        return this.bindI18nAnnotations;
    }

    public List<FieldAnnotation> getDeepBindEntityAnnotations() {
        return this.deepBindEntityAnnotations;
    }

    public List<FieldAnnotation> getDeepBindEntityListAnnotations() {
        return this.deepBindEntityListAnnotations;
    }

    public boolean isEmpty() {
        return V.isAllEmpty(this.bindDictAnnotations, this.bindFieldGroupMap, this.bindEntityAnnotations, this.bindEntityListAnnotations, this.bindFieldListGroupMap, this.bindCountAnnotations, this.bindI18nAnnotations);
    }

    public boolean isRequireSequential() {
        return this.requireSequential;
    }
}

