/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.parser;

import com.diboot.core.binding.parser.ConditionParser;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConditionManager {
    private static final Logger log = LoggerFactory.getLogger(BaseConditionManager.class);
    private static final Map<String, List<Expression>> expressionParseResultMap = new ConcurrentHashMap<String, List<Expression>>();

    protected static List<Expression> getExpressionList(String condition) {
        if (V.isEmpty(condition)) {
            return null;
        }
        List<Expression> expressionList = expressionParseResultMap.get(condition);
        if (expressionList == null) {
            ConditionParser visitor = new ConditionParser();
            try {
                Expression expression = CCJSqlParserUtil.parseCondExpression((String)condition);
                expression.accept((ExpressionVisitor)visitor);
                expressionList = visitor.getExpressList();
                expressionParseResultMap.put(condition, expressionList);
            }
            catch (Exception e) {
                log.error("\u5173\u8054\u6761\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
        }
        return expressionList;
    }

    protected static String extractMiddleTableName(List<Expression> expressionList) {
        HashSet<String> tableNameSet = new HashSet<String>();
        for (Expression operator : expressionList) {
            EqualsTo express;
            if (!(operator instanceof EqualsTo) || !((express = (EqualsTo)operator).getLeftExpression() instanceof Column) || !(express.getRightExpression() instanceof Column)) continue;
            String leftColumn = express.getLeftExpression().toString();
            BaseConditionManager.collectTableName(tableNameSet, leftColumn);
            String rightColumn = express.getRightExpression().toString();
            BaseConditionManager.collectTableName(tableNameSet, rightColumn);
        }
        if (tableNameSet.isEmpty()) {
            return null;
        }
        if (tableNameSet.size() > 1) {
            log.warn("\u4e2d\u95f4\u8868\u5173\u8054\u6761\u4ef6\u6682\u53ea\u652f\u63011\u5f20\u4e2d\u95f4\u8868\uff01");
        }
        return (String)tableNameSet.iterator().next();
    }

    private static void collectTableName(Set<String> tableNameSet, String columnStr) {
        if (!columnStr.contains(".")) {
            return;
        }
        if (!BaseConditionManager.isCurrentObjColumn(columnStr)) {
            String tempTableName = S.substringBefore((String)columnStr, (String)".");
            tableNameSet.add(tempTableName);
        }
    }

    protected static boolean isCurrentObjColumn(String expression) {
        String tempTableName = S.substringBefore((String)expression, (String)".");
        return "this".equals(tempTableName) || "self".equals(tempTableName);
    }
}

