/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.helper;

import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;

public class ResultAssembler {
    private static final Logger log = LoggerFactory.getLogger(ResultAssembler.class);

    public static <E> void bindCountPropValue(String setterFieldName, List<E> fromList, String[] getterFields, Map valueMatchMap) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        try {
            for (E object : fromList) {
                ArrayList<String> matchKeys = null;
                BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(object);
                for (int i = 0; i < getterFields.length; ++i) {
                    Object fieldValueObj = BeanUtils.getProperty(object, getterFields[i]);
                    if (fieldValueObj == null) continue;
                    if (fieldValueObj instanceof Collection) {
                        if (matchKeys == null) {
                            matchKeys = new ArrayList<String>();
                        }
                        matchKeys.addAll((Collection)fieldValueObj);
                        continue;
                    }
                    if (matchKeys == null) {
                        matchKeys = new ArrayList(getterFields.length);
                    }
                    matchKeys.add(S.clearNonConst(S.valueOf(fieldValueObj)));
                }
                if (matchKeys == null) continue;
                String matchKey = S.join(matchKeys);
                if (valueMatchMap.containsKey(matchKey)) {
                    beanWrapper.setPropertyValue(setterFieldName, valueMatchMap.get(matchKey));
                    continue;
                }
                Object matchedValue = valueMatchMap.get(matchKey);
                if (matchedValue == null) {
                    matchedValue = 0L;
                }
                beanWrapper.setPropertyValue(setterFieldName, matchedValue);
            }
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38, setterFieldName=" + setterFieldName, (Throwable)e);
        }
    }

    public static <E> void bindPropValue(String setterFieldName, List<E> fromList, String[] getterFields, Map valueMatchMap, String splitBy) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        try {
            for (E object : fromList) {
                List<String> matchKeys = null;
                BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(object);
                for (int i = 0; i < getterFields.length; ++i) {
                    Object fieldValueObj = BeanUtils.getProperty(object, getterFields[i]);
                    if (fieldValueObj == null) continue;
                    if (fieldValueObj instanceof Collection) {
                        if (matchKeys == null) {
                            matchKeys = new ArrayList<String>();
                        }
                        matchKeys.addAll((Collection)fieldValueObj);
                        continue;
                    }
                    if (matchKeys == null) {
                        matchKeys = new ArrayList(getterFields.length);
                    }
                    matchKeys.add(S.clearNonConst(S.valueOf(fieldValueObj)));
                }
                if (matchKeys == null) continue;
                String matchKey = S.join(matchKeys);
                if (valueMatchMap.containsKey(matchKey)) {
                    beanWrapper.setPropertyValue(setterFieldName, valueMatchMap.get(matchKey));
                    continue;
                }
                if (matchKeys.size() == 1 && V.notEmpty(splitBy) && getterFields.length == 1 && matchKey.contains(splitBy)) {
                    matchKeys = S.splitToList(matchKey, splitBy);
                }
                ArrayList<Object> matchedValues = new ArrayList<Object>(matchKeys.size());
                for (Object e : matchKeys) {
                    Object value = valueMatchMap.get(S.valueOf(e));
                    if (value == null) continue;
                    if (value instanceof Collection) {
                        Collection valueList = (Collection)value;
                        for (Object obj : valueList) {
                            if (matchedValues.contains(obj)) continue;
                            matchedValues.add(obj);
                        }
                        continue;
                    }
                    if (matchedValues.contains(value)) continue;
                    matchedValues.add(value);
                }
                beanWrapper.setPropertyValue(setterFieldName, matchedValues);
            }
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38, setterFieldName=" + setterFieldName, (Throwable)e);
        }
    }

    public static <E> void bindEntityPropValue(String setterFieldName, List<E> fromList, Map<String, String> trunkObjColMapping, Map valueMatchMap, Map<String, String> col2FieldMapping) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (E object : fromList) {
                boolean appendComma = false;
                sb.setLength(0);
                for (Map.Entry<String, String> entry : trunkObjColMapping.entrySet()) {
                    String getterField = col2FieldMapping.get(entry.getKey());
                    if (getterField == null) {
                        getterField = S.toLowerCaseCamel(entry.getKey());
                    }
                    String fieldValue = BeanUtils.getStringProperty(object, getterField);
                    if (appendComma) {
                        sb.append(",");
                    }
                    sb.append(fieldValue);
                    if (appendComma) continue;
                    appendComma = true;
                }
                String matchKey = sb.toString();
                if (!valueMatchMap.containsKey(matchKey)) continue;
                BeanUtils.setProperty(object, setterFieldName, valueMatchMap.get(matchKey));
            }
            sb.setLength(0);
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38, setterFieldName=" + setterFieldName, (Throwable)e);
        }
    }

    public static <E> void bindFieldListPropValue(List<E> fromList, String[] getterFields, Map<String, List> valueMatchMap, List<String> annoObjSetterPropNameList, List<String> refGetterFieldNameList, String splitBy) {
        if (V.isEmpty(fromList) || V.isEmpty(valueMatchMap)) {
            return;
        }
        try {
            for (E object : fromList) {
                List<String> matchKeys = null;
                for (int i = 0; i < getterFields.length; ++i) {
                    Object fieldValueObj = BeanUtils.getProperty(object, getterFields[i]);
                    if (fieldValueObj == null) continue;
                    if (fieldValueObj instanceof Collection) {
                        if (matchKeys == null) {
                            matchKeys = new ArrayList<String>();
                        }
                        matchKeys.addAll((Collection)fieldValueObj);
                        continue;
                    }
                    if (matchKeys == null) {
                        matchKeys = new ArrayList(getterFields.length);
                    }
                    matchKeys.add(S.clearNonConst(S.valueOf(fieldValueObj)));
                }
                if (matchKeys == null) continue;
                String matchKey = S.join(matchKeys);
                ArrayList entityList = valueMatchMap.get(matchKey);
                if (entityList == null) {
                    if (matchKeys.size() == 1 && V.notEmpty(splitBy) && matchKey.contains(splitBy)) {
                        matchKeys = S.splitToList(matchKey, splitBy);
                    }
                    ArrayList matchedValues = new ArrayList(matchKeys.size());
                    for (Object e : matchKeys) {
                        List value = valueMatchMap.get(S.valueOf(e));
                        if (value == null) continue;
                        Collection valueList = value;
                        for (Object obj : valueList) {
                            if (matchedValues.contains(obj)) continue;
                            matchedValues.add(obj);
                        }
                    }
                    entityList = matchedValues;
                }
                BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(object);
                for (int i = 0; i < annoObjSetterPropNameList.size(); ++i) {
                    List list = BeanUtils.collectToList(entityList, refGetterFieldNameList.get(i));
                    beanWrapper.setPropertyValue(annoObjSetterPropNameList.get(i), (Object)list);
                }
            }
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38", (Throwable)e);
        }
    }

    public static <E> Map<String, Object> convertToOneToOneResult(List<Map<String, E>> resultSetMapList, Map<String, String> trunkObjColMapping, Map<String, String> branchObjColMapping) {
        if (V.isEmpty(resultSetMapList)) {
            return Collections.emptyMap();
        }
        String valueName = branchObjColMapping.entrySet().iterator().next().getKey();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(resultSetMapList.size());
        StringBuilder sb = new StringBuilder();
        for (Map<String, E> row : resultSetMapList) {
            boolean appendComma = false;
            sb.setLength(0);
            for (Map.Entry<String, String> entry : trunkObjColMapping.entrySet()) {
                Object keyObj = ResultAssembler.getValueIgnoreKeyCase(row, entry.getValue());
                if (appendComma) {
                    sb.append(",");
                }
                sb.append(S.valueOf(keyObj));
                if (appendComma) continue;
                appendComma = true;
            }
            String matchKeys = sb.toString();
            E valueObj = row.containsKey(valueName) ? row.get(valueName) : row.get(valueName.toUpperCase());
            resultMap.put(matchKeys, valueObj);
        }
        return resultMap;
    }

    public static <E> Map<String, Long> convertToOneToManyCountResult(List<Map<String, E>> resultSetMapList, Map<String, String> trunkObjColMapping, Map<String, String> branchObjColMapping) {
        if (V.isEmpty(resultSetMapList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        StringBuilder sb = new StringBuilder();
        for (Map<String, E> row : resultSetMapList) {
            boolean appendComma = false;
            sb.setLength(0);
            for (Map.Entry<String, String> entry : trunkObjColMapping.entrySet()) {
                Object keyObj = ResultAssembler.getValueIgnoreKeyCase(row, entry.getValue());
                if (appendComma) {
                    sb.append(",");
                }
                sb.append(S.valueOf(keyObj));
                if (appendComma) continue;
                appendComma = true;
            }
            String matchKeys = sb.toString();
            Long valueObj = (Long)ResultAssembler.getValueIgnoreKeyCase(row, "_cnt");
            if (valueObj == null) {
                valueObj = 0L;
            }
            resultMap.put(matchKeys, valueObj);
        }
        sb.setLength(0);
        return resultMap;
    }

    public static <E> Map<String, List> convertToOneToManyResult(List<Map<String, E>> resultSetMapList, Map<String, String> trunkObjColMapping, Map<String, String> branchObjColMapping) {
        if (V.isEmpty(resultSetMapList)) {
            return Collections.emptyMap();
        }
        String valueName = branchObjColMapping.entrySet().iterator().next().getKey();
        valueName = S.removeEsc(valueName);
        HashMap<String, List> resultMap = new HashMap<String, List>();
        StringBuilder sb = new StringBuilder();
        for (Map<String, E> row : resultSetMapList) {
            boolean appendComma = false;
            sb.setLength(0);
            for (Map.Entry<String, String> entry : trunkObjColMapping.entrySet()) {
                Object keyObj = ResultAssembler.getValueIgnoreKeyCase(row, entry.getValue());
                if (appendComma) {
                    sb.append(",");
                }
                sb.append(S.valueOf(keyObj));
                if (appendComma) continue;
                appendComma = true;
            }
            String matchKeys = sb.toString();
            E valueObj = row.containsKey(valueName) ? row.get(valueName) : row.get(valueName.toUpperCase());
            if (valueObj == null) continue;
            List valueList = resultMap.computeIfAbsent(matchKeys, k -> new ArrayList());
            valueList.add(valueObj);
        }
        sb.setLength(0);
        return resultMap;
    }

    public static Object getValueIgnoreKeyCase(Map<String, ?> map, String key) {
        if (map == null || key == null) {
            return null;
        }
        if (map.containsKey(key = S.removeEsc(key))) {
            return map.get(key);
        }
        if (map.containsKey(key.toUpperCase())) {
            return map.get(key.toUpperCase());
        }
        return null;
    }

    public static List unpackValueList(List valueList, String splitBy, Class<?> fieldType) {
        if (V.isEmpty(valueList)) {
            return valueList;
        }
        ArrayList newValueList = new ArrayList();
        for (Object value : valueList) {
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object key : (Collection)value) {
                    if (newValueList.contains(key)) continue;
                    newValueList.add(key);
                }
                continue;
            }
            if (V.notEmpty(splitBy)) {
                boolean isSameType = fieldType == null || fieldType.equals(String.class);
                String valueStr = S.clearNonConst(S.valueOf(value));
                if (valueStr.contains(splitBy)) {
                    for (String oneVal : valueStr.split(splitBy)) {
                        String oneValueObj;
                        String string = oneValueObj = isSameType ? oneVal : BeanUtils.convertValueToFieldType((Object)oneVal, fieldType);
                        if (newValueList.contains(oneValueObj)) continue;
                        newValueList.add(oneValueObj);
                    }
                    continue;
                }
                Object oneValueObj = isSameType ? value : BeanUtils.convertValueToFieldType(value, fieldType);
                if (newValueList.contains(oneValueObj)) continue;
                newValueList.add(oneValueObj);
                continue;
            }
            if (newValueList.contains(value)) continue;
            newValueList.add(value);
        }
        return newValueList;
    }
}

