/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder.parallel;

import com.diboot.core.binding.annotation.BindCount;
import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.binding.annotation.BindEntity;
import com.diboot.core.binding.annotation.BindEntityList;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.binding.annotation.BindFieldList;
import com.diboot.core.binding.annotation.BindI18n;
import com.diboot.core.binding.binder.BaseBinder;
import com.diboot.core.binding.binder.CountBinder;
import com.diboot.core.binding.binder.EntityBinder;
import com.diboot.core.binding.binder.EntityListBinder;
import com.diboot.core.binding.binder.FieldBinder;
import com.diboot.core.binding.binder.FieldListBinder;
import com.diboot.core.binding.parser.ConditionManager;
import com.diboot.core.binding.parser.FieldAnnotation;
import com.diboot.core.service.DictionaryServiceExtProvider;
import com.diboot.core.service.I18nConfigService;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParallelBindingManager {
    private static final Logger log = LoggerFactory.getLogger(ParallelBindingManager.class);
    @Autowired(required=false)
    private DictionaryServiceExtProvider dictionaryServiceExtProvider;
    @Autowired(required=false)
    private I18nConfigService i18nConfigService;

    @Async
    public CompletableFuture<Boolean> doBindingDict(List voList, FieldAnnotation fieldAnno) {
        if (this.dictionaryServiceExtProvider != null) {
            BindDict annotation = (BindDict)fieldAnno.getAnnotation();
            String dictValueField = annotation.field();
            if (V.isEmpty(dictValueField)) {
                dictValueField = S.replace((String)fieldAnno.getFieldName(), (String)"Label", (String)"");
                log.debug("BindDict\u672a\u6307\u5b9afield\uff0c\u5c06\u9ed8\u8ba4\u53d6\u503c\u4e3a: {}", (Object)dictValueField);
            }
            this.dictionaryServiceExtProvider.bindItemLabel(voList, fieldAnno.getFieldName(), dictValueField, annotation.type());
        } else {
            log.warn("BindDictService\u672a\u5b9e\u73b0\uff0c\u65e0\u6cd5\u4f7f\u7528BindDict\u6ce8\u89e3\uff01");
        }
        return CompletableFuture.completedFuture(true);
    }

    @Async
    public CompletableFuture<Boolean> doBindingField(List voList, List<FieldAnnotation> fieldAnnotations) {
        BindField bindAnnotation = (BindField)fieldAnnotations.get(0).getAnnotation();
        FieldBinder binder = new FieldBinder(bindAnnotation, voList);
        for (FieldAnnotation anno : fieldAnnotations) {
            BindField bindField = (BindField)anno.getAnnotation();
            binder.link(bindField.field(), anno.getFieldName());
        }
        return this.doBinding(binder, bindAnnotation.condition());
    }

    @Async
    public CompletableFuture<Boolean> doBindingFieldList(List voList, List<FieldAnnotation> fieldAnnotations) {
        BindFieldList bindAnnotation = (BindFieldList)fieldAnnotations.get(0).getAnnotation();
        FieldListBinder binder = new FieldListBinder(bindAnnotation, voList);
        for (FieldAnnotation anno : fieldAnnotations) {
            BindFieldList bindField = (BindFieldList)anno.getAnnotation();
            binder.link(bindField.field(), anno.getFieldName());
        }
        return this.doBinding(binder, bindAnnotation.condition());
    }

    @Async
    public CompletableFuture<Boolean> doBindingEntity(List voList, FieldAnnotation fieldAnnotation) {
        BindEntity annotation = (BindEntity)fieldAnnotation.getAnnotation();
        EntityBinder binder = new EntityBinder(annotation, voList);
        binder.set(fieldAnnotation.getFieldName(), fieldAnnotation.getFieldClass());
        return this.doBinding(binder, annotation.condition());
    }

    @Async
    public CompletableFuture<Boolean> doBindingEntityList(List voList, FieldAnnotation fieldAnnotation) {
        BindEntityList annotation = (BindEntityList)fieldAnnotation.getAnnotation();
        EntityListBinder binder = new EntityListBinder(annotation, voList);
        binder.set(fieldAnnotation.getFieldName(), fieldAnnotation.getFieldClass());
        return this.doBinding(binder, annotation.condition());
    }

    @Async
    public CompletableFuture<Boolean> doBindingCount(List voList, FieldAnnotation fieldAnnotation) {
        BindCount annotation = (BindCount)fieldAnnotation.getAnnotation();
        CountBinder binder = new CountBinder(annotation, voList);
        binder.set(fieldAnnotation.getFieldName(), fieldAnnotation.getFieldClass());
        return this.doBinding(binder, annotation.condition());
    }

    @Async
    public CompletableFuture<Boolean> doBindingI18n(List voList, FieldAnnotation fieldAnnotation) {
        BindI18n annotation = (BindI18n)fieldAnnotation.getAnnotation();
        String i18nCodeField = annotation.value();
        if (this.i18nConfigService != null) {
            this.i18nConfigService.bindI18nContent(voList, i18nCodeField, fieldAnnotation.getFieldName());
        } else {
            log.warn("I18nConfigService\u672a\u5b9e\u73b0\uff0c\u65e0\u6cd5\u7ffb\u8bd1I18n\u6ce8\u89e3: {}", (Object)i18nCodeField);
        }
        return CompletableFuture.completedFuture(true);
    }

    private CompletableFuture<Boolean> doBinding(BaseBinder binder, String condition) {
        ConditionManager.parseConditions(condition, binder);
        binder.bind();
        return CompletableFuture.completedFuture(true);
    }
}

