/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.diboot.core.binding.annotation.BindField;
import com.diboot.core.binding.binder.BaseBinder;
import com.diboot.core.binding.binder.remote.RemoteBindingManager;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.IGetter;
import com.diboot.core.util.ISetter;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;

public class FieldBinder<T>
extends BaseBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(FieldBinder.class);
    protected List<String> annoObjectSetterPropNameList;
    protected List<String> referencedGetterFieldNameList;

    public FieldBinder(Class<T> entityClass, List voList) {
        super(entityClass, voList);
    }

    public FieldBinder(BindField annotation, List voList) {
        super(annotation.entity(), voList);
    }

    public <T1, T2, R> FieldBinder<T> link(IGetter<T2> fromDoGetter, ISetter<T1, R> toVoSetter) {
        return this.link(BeanUtils.convertToFieldName(fromDoGetter), BeanUtils.convertToFieldName(toVoSetter));
    }

    public FieldBinder<T> link(String fromDoField, String toVoField) {
        if (this.annoObjectSetterPropNameList == null) {
            this.annoObjectSetterPropNameList = new ArrayList<String>(4);
        }
        this.annoObjectSetterPropNameList.add(toVoField);
        if (this.referencedGetterFieldNameList == null) {
            this.referencedGetterFieldNameList = new ArrayList<String>(4);
        }
        this.referencedGetterFieldNameList.add(fromDoField);
        return this;
    }

    @Override
    public void bind() {
        if (V.isEmpty(this.annoObjectList)) {
            return;
        }
        if (V.isEmpty(this.refObjJoinCols)) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u65e0\u6cd5\u4ececondition\u4e2d\u89e3\u6790\u51fa\u5b57\u6bb5\u5173\u8054.", new Object[0]);
        }
        if (this.referencedGetterFieldNameList == null) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u5b57\u6bb5\u7ed1\u5b9a\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5field", new Object[0]);
        }
        if (this.middleTable == null) {
            this.simplifySelectColumns();
            super.buildQueryWrapperJoinOn();
            if (this.queryWrapper.isEmptyOfNormal()) {
                return;
            }
            List entityList = V.isEmpty(this.module) ? this.getEntityList((Wrapper)this.queryWrapper) : RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            if (V.isEmpty(entityList)) {
                return;
            }
            Map key2EntityMap = this.buildMatchKey2EntityMap(entityList);
            for (Object annoObject : super.getMatchedAnnoObjectList()) {
                String matchKey = this.buildMatchKey(annoObject);
                this.setFieldValueToTrunkObj(key2EntityMap, annoObject, matchKey);
            }
        } else {
            List entityList;
            if (this.refObjJoinCols.size() > 1) {
                throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
            }
            Map<String, List> trunkObjCol2ValuesMap = super.buildTrunkObjCol2ValuesMap();
            Map<String, Object> middleTableResultMap = this.middleTable.executeOneToOneQuery(trunkObjCol2ValuesMap);
            if (V.isEmpty(middleTableResultMap)) {
                return;
            }
            Collection refObjValues = middleTableResultMap.values().stream().distinct().collect(Collectors.toList());
            this.simplifySelectColumns();
            String refObjJoinOnCol = (String)this.refObjJoinCols.get(0);
            if (V.isEmpty(this.module)) {
                this.queryWrapper.in((Object)refObjJoinOnCol, refObjValues);
                entityList = this.getEntityList((Wrapper)this.queryWrapper);
            } else {
                this.remoteBindDTO.setRefJoinCol(refObjJoinOnCol).setInConditionValues(refObjValues);
                entityList = RemoteBindingManager.fetchEntityList(this.module, this.remoteBindDTO, this.referencedEntityClass);
            }
            if (V.isEmpty(entityList)) {
                return;
            }
            Map key2EntityMap = this.buildMatchKey2EntityMap(entityList);
            for (Object annoObject : super.getMatchedAnnoObjectList()) {
                String matchKey = this.buildMatchKey(annoObject, middleTableResultMap);
                this.setFieldValueToTrunkObj(key2EntityMap, annoObject, matchKey);
            }
        }
    }

    private void setFieldValueToTrunkObj(Map<String, T> key2EntityMap, Object annoObject, String matchKey) {
        T relationEntity = key2EntityMap.get(matchKey);
        if (relationEntity != null) {
            BeanWrapper beanWrapper = BeanUtils.getBeanWrapper(annoObject);
            for (int i = 0; i < this.annoObjectSetterPropNameList.size(); ++i) {
                Object valObj = BeanUtils.getProperty(relationEntity, this.referencedGetterFieldNameList.get(i));
                beanWrapper.setPropertyValue(this.annoObjectSetterPropNameList.get(i), valObj);
            }
        }
    }

    protected Map<String, T> buildMatchKey2EntityMap(List<T> entityList) {
        HashMap<String, T> key2TargetMap = new HashMap<String, T>(entityList.size());
        for (T entity : entityList) {
            ArrayList<String> joinOnValues = new ArrayList<String>(this.refObjJoinCols.size());
            for (String refObjJoinOnCol : this.refObjJoinCols) {
                Object valObj = BeanUtils.getProperty(entity, this.toRefObjField(refObjJoinOnCol));
                joinOnValues.add(S.valueOf(valObj));
            }
            String matchKey = S.join(joinOnValues);
            if (matchKey == null) continue;
            key2TargetMap.put(matchKey, entity);
        }
        return key2TargetMap;
    }

    private String buildMatchKey(Object annoObject) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.annoObjJoinCols.size(); ++i) {
            String col = (String)this.annoObjJoinCols.get(i);
            String val = BeanUtils.getStringProperty(annoObject, this.toAnnoObjField(col));
            if (i > 0) {
                sb.append(",");
            }
            sb.append(val);
        }
        return sb.toString();
    }

    private String buildMatchKey(Object annoObject, Map<String, Object> middleTableResultMap) {
        StringBuilder sb = new StringBuilder();
        boolean appendComma = false;
        for (Map.Entry<String, String> entry : this.middleTable.getTrunkObjColMapping().entrySet()) {
            String getterField = this.toAnnoObjField(entry.getKey());
            String fieldValue = BeanUtils.getStringProperty(annoObject, getterField);
            if (appendComma) {
                sb.append(",");
            }
            sb.append(fieldValue);
            if (appendComma) continue;
            appendComma = true;
        }
        String matchKey = sb.toString();
        if (V.notEmpty(middleTableResultMap) && middleTableResultMap.containsKey(matchKey)) {
            Object value = middleTableResultMap.get(matchKey);
            matchKey = S.valueOf(value);
        }
        return matchKey;
    }

    @Override
    protected void simplifySelectColumns() {
        ArrayList<String> selectColumns = new ArrayList<String>(8);
        selectColumns.addAll(this.refObjJoinCols);
        if (V.notEmpty(this.referencedGetterFieldNameList)) {
            for (String referencedGetterField : this.referencedGetterFieldNameList) {
                String refObjCol = this.toRefObjColumn(referencedGetterField);
                if (selectColumns.contains(refObjCol)) continue;
                selectColumns.add(refObjCol);
            }
        }
        if (V.notEmpty(this.orderBy)) {
            String[] orderByFields;
            for (String field : orderByFields = S.split(this.orderBy)) {
                String colName = field.toLowerCase();
                if (colName.contains(":")) {
                    colName = S.split((String)colName, (String)":")[0];
                }
                if (selectColumns.contains(colName = this.toRefObjColumn(colName))) continue;
                selectColumns.add(colName);
            }
        }
        if (this.remoteBindDTO != null) {
            this.remoteBindDTO.setSelectColumns(selectColumns);
        }
        this.queryWrapper.select(selectColumns);
    }
}

