/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.diboot.core.binding.annotation.BindCount;
import com.diboot.core.binding.binder.EntityListBinder;
import com.diboot.core.binding.binder.remote.RemoteBindingManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.MapUtils;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountBinder<T>
extends EntityListBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(CountBinder.class);

    public CountBinder(BindCount annotation, List voList) {
        super(annotation.entity(), voList);
    }

    @Override
    public void bind() {
        if (V.isEmpty(this.annoObjectList)) {
            return;
        }
        if (V.isEmpty(this.refObjJoinCols)) {
            throw new InvalidUsageException("\u8c03\u7528\u9519\u8bef\uff1a\u65e0\u6cd5\u4ececondition\u4e2d\u89e3\u6790\u51fa\u5b57\u6bb5\u5173\u8054.", new Object[0]);
        }
        if (this.middleTable == null) {
            this.simplifySelectColumns();
            super.buildQueryWrapperJoinOn();
            if (this.queryWrapper.isEmptyOfNormal()) {
                return;
            }
            this.queryWrapper.groupBy(this.refObjJoinCols);
            List<Map<String, Object>> countMapList = V.isEmpty(this.module) ? this.getCountMapList((Wrapper)this.queryWrapper) : RemoteBindingManager.fetchMapList(this.module, this.remoteBindDTO);
            if (V.notEmpty(countMapList)) {
                Map<String, Long> valueListCountMap = this.buildMatchKey2ListCountMap(countMapList);
                ResultAssembler.bindCountPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.getAnnoObjJoinFlds(), valueListCountMap);
            }
        } else {
            if (this.refObjJoinCols.size() > 1) {
                throw new InvalidUsageException("\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!", new Object[0]);
            }
            Map<String, List> trunkObjCol2ValuesMap = super.buildTrunkObjCol2ValuesMap();
            Map<String, Long> middleTableCountResultMap = this.middleTable.executeOneToManyCountQuery(trunkObjCol2ValuesMap);
            if (V.isEmpty(middleTableCountResultMap)) {
                return;
            }
            HashMap<String, Long> valueListCountMap = new HashMap<String, Long>();
            for (Map.Entry<String, Long> entry : middleTableCountResultMap.entrySet()) {
                Long count = entry.getValue();
                if (V.isEmpty(count)) {
                    count = 0L;
                }
                valueListCountMap.put(entry.getKey(), count);
            }
            ResultAssembler.bindCountPropValue(this.annoObjectField, super.getMatchedAnnoObjectList(), this.getAnnoObjJoinFlds(), valueListCountMap);
        }
    }

    @Override
    protected void simplifySelectColumns() {
        ArrayList<String> selectColumns = new ArrayList<String>(8);
        selectColumns.addAll(this.refObjJoinCols);
        selectColumns.add("count(*) AS _cnt");
        if (this.remoteBindDTO != null) {
            this.remoteBindDTO.setSelectColumns(selectColumns);
        }
        this.queryWrapper.select(selectColumns);
    }

    private List<Map<String, Object>> getCountMapList(Wrapper queryWrapper) {
        if (this.referencedService instanceof BaseService) {
            return ((BaseService)this.referencedService).getMapList(queryWrapper);
        }
        return this.referencedService.listMaps(queryWrapper);
    }

    private Map<String, Long> buildMatchKey2ListCountMap(List<Map<String, Object>> mapCountList) {
        HashMap<String, Long> key2TargetCountMap = new HashMap<String, Long>(mapCountList.size());
        if (V.isEmpty(mapCountList)) {
            return Collections.emptyMap();
        }
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> countMap : mapCountList) {
            sb.setLength(0);
            for (int i = 0; i < this.refObjJoinCols.size(); ++i) {
                Object pkValue = MapUtils.getIgnoreCase(countMap, (String)this.refObjJoinCols.get(i));
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(pkValue);
            }
            String matchKey = sb.toString();
            Long entityCount = (Long)MapUtils.getIgnoreCase(countMap, "_cnt");
            key2TargetCountMap.put(matchKey, entityCount);
        }
        sb.setLength(0);
        return key2TargetCountMap;
    }
}

