/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding.binder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.diboot.core.binding.annotation.Module;
import com.diboot.core.binding.binder.remote.RemoteBindDTO;
import com.diboot.core.binding.cache.BindingCacheManager;
import com.diboot.core.binding.helper.ResultAssembler;
import com.diboot.core.binding.helper.WrapperHelper;
import com.diboot.core.binding.parser.FieldComparison;
import com.diboot.core.binding.parser.MiddleTable;
import com.diboot.core.binding.parser.PropInfo;
import com.diboot.core.binding.query.Comparison;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.BaseService;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.IGetter;
import com.diboot.core.util.PropertiesUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBinder<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseBinder.class);
    protected List<?> annoObjectList;
    protected List<String> annoObjJoinCols;
    protected List<FieldComparison> annoObjJoinFieldComparisons;
    protected List<String> refObjJoinCols;
    protected IService<T> referencedService;
    protected QueryWrapper<T> queryWrapper;
    protected MiddleTable middleTable;
    protected Class<T> referencedEntityClass;
    protected PropInfo annoObjPropInfo;
    protected PropInfo refObjPropInfo;
    public static final String NOT_SUPPORT_MSG = "\u4e2d\u95f4\u8868\u5173\u8054\u6682\u4e0d\u652f\u6301\u6d89\u53ca\u76ee\u6807\u8868\u591a\u5217\u7684\u60c5\u51b5!";
    protected String splitBy = null;
    protected String orderBy;
    protected String module;
    protected RemoteBindDTO remoteBindDTO;

    public BaseBinder(Class<T> entityClass, List voList) {
        this.referencedEntityClass = entityClass;
        this.annoObjectList = voList;
        if (V.notEmpty(voList)) {
            this.annoObjPropInfo = BindingCacheManager.getPropInfoByClass(voList.get(0).getClass());
        }
        this.queryWrapper = new QueryWrapper();
        this.refObjPropInfo = BindingCacheManager.getPropInfoByClass(this.referencedEntityClass);
        Module moduleAnno = (Module)AnnotationUtils.findAnnotation(this.referencedEntityClass, Module.class);
        this.referencedService = this.getService(entityClass, moduleAnno);
        if (moduleAnno != null) {
            String applicationName = PropertiesUtils.get("spring.application.name");
            if (V.notEquals(moduleAnno.value(), applicationName)) {
                this.module = moduleAnno.value();
                this.remoteBindDTO = new RemoteBindDTO(this.referencedEntityClass);
            }
        }
        this.annoObjJoinCols = new ArrayList<String>(4);
        this.refObjJoinCols = new ArrayList<String>(4);
    }

    @Deprecated
    public <T1, T2> BaseBinder<T> joinOn(IGetter<T1> annoObjectFkGetter, IGetter<T2> referencedEntityPkGetter) {
        String annoObjectForeignKey = this.toAnnoObjColumn(BeanUtils.convertToFieldName(annoObjectFkGetter));
        String referencedEntityPrimaryKey = this.toRefObjColumn(BeanUtils.convertToFieldName(referencedEntityPkGetter));
        return this.joinOn(annoObjectForeignKey, referencedEntityPrimaryKey);
    }

    public BaseBinder<T> additionalCondition(String condition) {
        if (this.remoteBindDTO == null) {
            return this;
        }
        List<String> bindDTOWhere = this.remoteBindDTO.getAdditionalConditions();
        if (bindDTOWhere == null) {
            bindDTOWhere = new ArrayList<String>();
            this.remoteBindDTO.setAdditionalConditions(bindDTOWhere);
        }
        bindDTOWhere.add(condition);
        return this;
    }

    public BaseBinder<T> joinOn(String annoObjectForeignKey, String referencedEntityPrimaryKey) {
        if (annoObjectForeignKey != null && referencedEntityPrimaryKey != null) {
            this.annoObjJoinCols.add(annoObjectForeignKey);
            this.refObjJoinCols.add(referencedEntityPrimaryKey);
        }
        return this;
    }

    public BaseBinder<T> joinOnFieldComparison(String annoObjectFieldKey, Comparison comparison, Object eqFilterConsVal) {
        if (annoObjectFieldKey != null && eqFilterConsVal != null) {
            String fieldName;
            if (this.annoObjJoinFieldComparisons == null) {
                this.annoObjJoinFieldComparisons = new ArrayList<FieldComparison>(4);
            }
            if ((fieldName = this.annoObjPropInfo.getFieldByColumn(annoObjectFieldKey)) == null && this.annoObjPropInfo.getFieldToColumnMap().containsKey(annoObjectFieldKey)) {
                fieldName = annoObjectFieldKey;
            }
            if (fieldName == null) {
                throw new InvalidUsageException("\u5b57\u6bb5/\u5217 " + annoObjectFieldKey + " \u4e0d\u5b58\u5728", new Object[0]);
            }
            this.annoObjJoinFieldComparisons.add(new FieldComparison(fieldName, comparison, eqFilterConsVal));
        }
        return this;
    }

    public BaseBinder<T> andEQ(String fieldName, Object value) {
        this.queryWrapper.eq((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andNE(String fieldName, Object value) {
        this.queryWrapper.ne((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andGT(String fieldName, Object value) {
        this.queryWrapper.gt((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andGE(String fieldName, Object value) {
        this.queryWrapper.ge((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andLT(String fieldName, Object value) {
        this.queryWrapper.lt((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andLE(String fieldName, Object value) {
        this.queryWrapper.le((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andIsNotNull(String fieldName) {
        this.queryWrapper.isNotNull((Object)this.toRefObjColumn(fieldName));
        return this;
    }

    public BaseBinder<T> andIsNull(String fieldName) {
        this.queryWrapper.isNull((Object)this.toRefObjColumn(fieldName));
        return this;
    }

    public BaseBinder<T> andBetween(String fieldName, Object begin, Object end) {
        this.queryWrapper.between((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, begin), this.formatValue(fieldName, end));
        return this;
    }

    public BaseBinder<T> andLike(String fieldName, String value) {
        value = (String)this.formatValue(fieldName, value);
        fieldName = this.toRefObjColumn(fieldName);
        if (S.startsWith((CharSequence)value, (CharSequence)"%")) {
            if (S.endsWith((CharSequence)(value = S.substringAfter((String)value, (String)"%")), (CharSequence)"%")) {
                value = S.substringBeforeLast((String)value, (String)"%");
                this.queryWrapper.like((Object)fieldName, (Object)value);
            } else {
                this.queryWrapper.likeLeft((Object)fieldName, (Object)value);
            }
        } else if (S.endsWith((CharSequence)value, (CharSequence)"%")) {
            value = S.substringBeforeLast((String)value, (String)"%");
            this.queryWrapper.likeRight((Object)fieldName, (Object)value);
        } else {
            this.queryWrapper.like((Object)fieldName, (Object)value);
        }
        return this;
    }

    public BaseBinder<T> andIn(String fieldName, Collection valueList) {
        this.queryWrapper.in((Object)this.toRefObjColumn(fieldName), valueList);
        return this;
    }

    public BaseBinder<T> andNotIn(String fieldName, Collection valueList) {
        this.queryWrapper.notIn((Object)this.toRefObjColumn(fieldName), valueList);
        return this;
    }

    public BaseBinder<T> andNotBetween(String fieldName, Object begin, Object end) {
        this.queryWrapper.notBetween((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, begin), this.formatValue(fieldName, end));
        return this;
    }

    public BaseBinder<T> andNotLike(String fieldName, String value) {
        this.queryWrapper.notLike((Object)this.toRefObjColumn(fieldName), this.formatValue(fieldName, value));
        return this;
    }

    public BaseBinder<T> andApply(String applySql) {
        this.queryWrapper.apply(applySql, new Object[0]);
        return this;
    }

    public BaseBinder<T> withMiddleTable(MiddleTable middleTable) {
        this.middleTable = middleTable;
        return this;
    }

    public MiddleTable getMiddleTable() {
        return this.middleTable;
    }

    public List<String> getAnnoObjJoinCols() {
        return this.annoObjJoinCols;
    }

    public List<String> getRefObjJoinCols() {
        return this.refObjJoinCols;
    }

    public abstract void bind();

    protected void buildQueryWrapperJoinOn() {
        for (int i = 0; i < this.annoObjJoinCols.size(); ++i) {
            String annoObjJoinOnCol = this.annoObjJoinCols.get(i);
            List annoObjectJoinOnList = BeanUtils.collectToList(this.getMatchedAnnoObjectList(), this.toAnnoObjField(annoObjJoinOnCol));
            if (!V.notEmpty(annoObjectJoinOnList)) continue;
            String refObjJoinOnCol = this.refObjJoinCols.get(i);
            Class<?> fieldType = this.refObjPropInfo.getFieldTypeByColumn(refObjJoinOnCol);
            List unpackAnnoObjectJoinOnList = ResultAssembler.unpackValueList(annoObjectJoinOnList, this.splitBy, fieldType);
            this.queryWrapper.in((Object)refObjJoinOnCol, (Collection)unpackAnnoObjectJoinOnList);
            if (this.remoteBindDTO == null) continue;
            this.remoteBindDTO.setRefJoinCol(refObjJoinOnCol).setInConditionValues(unpackAnnoObjectJoinOnList);
        }
    }

    protected List<?> getMatchedAnnoObjectList() {
        return this.filterObjectList(this.annoObjectList, this.annoObjJoinFieldComparisons);
    }

    protected abstract void simplifySelectColumns();

    protected List<T> getEntityList(Wrapper queryWrapper) {
        if (this.referencedService instanceof BaseService) {
            return ((BaseService)this.referencedService).getEntityList(queryWrapper);
        }
        List list = this.referencedService.list(queryWrapper);
        return this.checkedList(list);
    }

    @Deprecated
    protected List<Map<String, Object>> getMapList(Wrapper queryWrapper) {
        if (this.referencedService instanceof BaseService) {
            return ((BaseService)this.referencedService).getMapList(queryWrapper);
        }
        List list = this.referencedService.listMaps(queryWrapper);
        return this.checkedList(list);
    }

    protected Map<String, List> buildTrunkObjCol2ValuesMap() {
        HashMap<String, List> trunkObjCol2ValuesMap = new HashMap<String, List>();
        for (Map.Entry<String, String> entry : this.middleTable.getTrunkObjColMapping().entrySet()) {
            String annoObjFld = this.toAnnoObjField(entry.getKey());
            List valueList = BeanUtils.collectToList(this.annoObjectList, annoObjFld);
            trunkObjCol2ValuesMap.put(entry.getValue(), valueList);
        }
        return trunkObjCol2ValuesMap;
    }

    protected Object getValueIgnoreKeyCase(Map<String, Object> map, String key) {
        return ResultAssembler.getValueIgnoreKeyCase(map, key);
    }

    protected List extractIdValueFromMap(Map<String, List> middleTableResultMap) {
        ArrayList entityIdList = new ArrayList();
        for (Map.Entry<String, List> entry : middleTableResultMap.entrySet()) {
            if (V.isEmpty(entry.getValue())) continue;
            for (Object id : entry.getValue()) {
                if (entityIdList.contains(id)) continue;
                entityIdList.add(id);
            }
        }
        return entityIdList;
    }

    public String[] getAnnoObjJoinFlds() {
        String[] fields = new String[this.annoObjJoinCols.size()];
        for (int i = 0; i < this.annoObjJoinCols.size(); ++i) {
            fields[i] = this.toAnnoObjField(this.annoObjJoinCols.get(i));
        }
        return fields;
    }

    public Map<String, String> getAnnoObjColumnToFieldMap() {
        return this.annoObjPropInfo.getColumnToFieldMap();
    }

    public String toAnnoObjField(String annoObjColumn) {
        String field = this.annoObjPropInfo.getColumnToFieldMap().get(annoObjColumn);
        if (field == null) {
            field = S.toLowerCaseCamel(annoObjColumn);
        }
        return field;
    }

    public String toAnnoObjColumn(String annoObjField) {
        String column = this.annoObjPropInfo.getFieldToColumnMap().get(annoObjField);
        if (column == null) {
            column = S.toSnakeCase(annoObjField);
        }
        return column;
    }

    public String toRefObjField(String refObjColumn) {
        String field = this.refObjPropInfo.getColumnToFieldMap().get(refObjColumn);
        if (field == null) {
            field = S.toLowerCaseCamel(refObjColumn);
        }
        return field;
    }

    public String toRefObjColumn(String refObjField) {
        String column = this.refObjPropInfo.getFieldToColumnMap().get(refObjField);
        if (column == null) {
            column = S.toSnakeCase(refObjField);
        }
        return column;
    }

    protected void appendOrderBy(RemoteBindDTO remoteBindDTO) {
        if (V.isEmpty(this.orderBy)) {
            return;
        }
        if (remoteBindDTO != null) {
            remoteBindDTO.setOrderBy(this.orderBy);
            return;
        }
        WrapperHelper.buildOrderBy(this.queryWrapper, this.orderBy, this::toRefObjColumn);
    }

    private IService<T> getService(Class<T> entityClass, Module moduleAnno) {
        IService iService = ContextHolder.getIServiceByEntity(entityClass);
        if (iService == null && moduleAnno == null) {
            throw new InvalidUsageException(entityClass.getSimpleName() + " \u65e0 BaseService/IService\u5b9e\u73b0\u7c7b\uff0c\u65e0\u6cd5\u6267\u884c\u6ce8\u89e3\u7ed1\u5b9a\uff01", new Object[0]);
        }
        return iService;
    }

    private List checkedList(List list) {
        if (list == null) {
            list = Collections.emptyList();
        } else if (list.size() > BaseConfig.getBatchSize()) {
            log.warn("\u5355\u6b21\u67e5\u8be2\u8bb0\u5f55\u6570\u91cf\u8fc7\u5927\uff0c\u8fd4\u56de\u7ed3\u679c\u6570={}\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)list.size());
        }
        return list;
    }

    private Object formatValue(String fieldName, Object value) {
        Field field;
        if (value instanceof String && S.contains((CharSequence)((String)value), (CharSequence)"'")) {
            return S.replace((String)((String)value), (String)"'", (String)"");
        }
        if (this.referencedEntityClass != null && (field = BeanUtils.extractField(this.referencedEntityClass, this.toRefObjField(fieldName))) != null) {
            return BeanUtils.convertValueToFieldType(value, field);
        }
        return value;
    }

    private <E> List filterObjectList(List<E> objectList, List<FieldComparison> filterConditions) {
        if (V.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        if (V.isEmpty(filterConditions)) {
            return objectList;
        }
        ArrayList<E> newObjectList = new ArrayList<E>();
        for (E object : objectList) {
            boolean matched = true;
            for (FieldComparison fieldCompare : filterConditions) {
                Object fieldValue = BeanUtils.getProperty(object, fieldCompare.getFieldName());
                if (Comparison.EQ.name().equals(fieldCompare.getComparison().name())) {
                    if (V.fuzzyEqual(fieldValue, fieldCompare.getValue())) continue;
                    matched = false;
                    break;
                }
                if (Comparison.NOT_EQ.name().equals(fieldCompare.getComparison().name())) {
                    if (!V.fuzzyEqual(fieldValue, fieldCompare.getValue())) continue;
                    matched = false;
                    break;
                }
                if (Comparison.CONTAINS.name().equals(fieldCompare.getComparison().name())) {
                    if (S.valueOf(fieldValue).contains((String)fieldCompare.getValue())) continue;
                    matched = false;
                    break;
                }
                if (Comparison.IN.name().equals(fieldCompare.getComparison().name())) {
                    List inValues = (List)fieldCompare.getValue();
                    boolean in = false;
                    for (Object value : inValues) {
                        if (!V.fuzzyEqual(fieldValue, value)) continue;
                        in = true;
                        break;
                    }
                    if (in) continue;
                    matched = false;
                    break;
                }
                if (Comparison.NOT_IN.name().equals(fieldCompare.getComparison().name())) {
                    List notInValues = (List)fieldCompare.getValue();
                    boolean notIn = true;
                    for (Object value : notInValues) {
                        if (!V.fuzzyEqual(fieldValue, value)) continue;
                        notIn = false;
                        break;
                    }
                    if (notIn) continue;
                    matched = false;
                    break;
                }
                log.warn("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u5bf9\u6bd4: {}", (Object)fieldCompare.getComparison().name());
            }
            if (!matched) {
                log.debug("{} \u4e0d\u5339\u914d {}\uff0c \u5ffd\u7565\u6536\u96c6\u8be5\u5b57\u6bb5", object, filterConditions);
                continue;
            }
            newObjectList.add(object);
        }
        return newObjectList;
    }
}

