/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding;

import com.diboot.core.binding.binder.parallel.ParallelBindingManager;
import com.diboot.core.binding.helper.DeepRelationsBinder;
import com.diboot.core.binding.parser.BindAnnotationGroup;
import com.diboot.core.binding.parser.FieldAnnotation;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RelationsBinder {
    private static final Logger log = LoggerFactory.getLogger(RelationsBinder.class);

    public static <E, VO> VO convertAndBind(E entity, Class<VO> voClass) {
        VO vo = BeanUtils.convert(entity, voClass);
        RelationsBinder.bind(vo);
        return vo;
    }

    public static <E, VO> List<VO> convertAndBind(List<E> entityList, Class<VO> voClass) {
        List<VO> voList = BeanUtils.convertList(entityList, voClass);
        RelationsBinder.bind(voList);
        return voList;
    }

    public static <VO> void bind(VO vo) {
        RelationsBinder.bind(Collections.singletonList(vo));
    }

    public static <VO> void bind(List<VO> voList) {
        RelationsBinder.bind(voList, true);
    }

    public static <VO> void bind(List<VO> voList, boolean enableDeepBind) {
        List<FieldAnnotation> list;
        List<FieldAnnotation> list2;
        Map<String, List<FieldAnnotation>> map;
        List<FieldAnnotation> list3;
        List<FieldAnnotation> list4;
        List<FieldAnnotation> dictAnnoList;
        if (V.isEmpty(voList)) {
            return;
        }
        Class<?> voClass = voList.get(0).getClass();
        BindAnnotationGroup bindAnnotationGroup = ParserCache.getBindAnnotationGroup(voClass);
        if (bindAnnotationGroup.isEmpty()) {
            return;
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        LocaleContextHolder.setLocaleContext((LocaleContext)LocaleContextHolder.getLocaleContext(), (boolean)true);
        ParallelBindingManager parallelBindingManager = ContextHolder.getBean(ParallelBindingManager.class);
        assert (parallelBindingManager != null);
        ArrayList<CompletableFuture<Boolean>> binderFutures = new ArrayList<CompletableFuture<Boolean>>();
        Map<String, List<FieldAnnotation>> bindFieldGroupMap = bindAnnotationGroup.getBindFieldGroupMap();
        if (bindFieldGroupMap != null) {
            for (Map.Entry<String, List<FieldAnnotation>> entry : bindFieldGroupMap.entrySet()) {
                CompletableFuture<Boolean> completableFuture = parallelBindingManager.doBindingField(voList, entry.getValue());
                binderFutures.add(completableFuture);
            }
        }
        if ((dictAnnoList = bindAnnotationGroup.getBindDictAnnotations()) != null) {
            if (bindAnnotationGroup.isRequireSequential()) {
                CompletableFuture.allOf(binderFutures.toArray(new CompletableFuture[0])).join();
            }
            for (FieldAnnotation fieldAnnotation : dictAnnoList) {
                CompletableFuture<Boolean> completableFuture = parallelBindingManager.doBindingDict(voList, fieldAnnotation);
                binderFutures.add(completableFuture);
            }
        }
        if ((list4 = bindAnnotationGroup.getBindEntityAnnotations()) != null) {
            for (FieldAnnotation fieldAnnotation : list4) {
                CompletableFuture<Boolean> completableFuture = parallelBindingManager.doBindingEntity(voList, fieldAnnotation);
                binderFutures.add(completableFuture);
            }
        }
        if ((list3 = bindAnnotationGroup.getBindEntityListAnnotations()) != null) {
            for (FieldAnnotation fieldAnnotation : list3) {
                CompletableFuture<Boolean> completableFuture = parallelBindingManager.doBindingEntityList(voList, fieldAnnotation);
                binderFutures.add(completableFuture);
            }
        }
        if ((map = bindAnnotationGroup.getBindFieldListGroupMap()) != null) {
            for (Map.Entry<String, List<FieldAnnotation>> entry : map.entrySet()) {
                CompletableFuture<Boolean> completableFuture = parallelBindingManager.doBindingFieldList(voList, entry.getValue());
                binderFutures.add(completableFuture);
            }
        }
        if ((list2 = bindAnnotationGroup.getBindCountAnnotations()) != null) {
            for (FieldAnnotation fieldAnnotation : list2) {
                CompletableFuture<Boolean> bindCountFuture = parallelBindingManager.doBindingCount(voList, fieldAnnotation);
                binderFutures.add(bindCountFuture);
            }
        }
        if ((list = bindAnnotationGroup.getBindI18nAnnotations()) != null) {
            for (FieldAnnotation anno : list) {
                CompletableFuture<Boolean> bindCountFuture = parallelBindingManager.doBindingI18n(voList, anno);
                binderFutures.add(bindCountFuture);
            }
        }
        CompletableFuture.allOf(binderFutures.toArray(new CompletableFuture[0])).join();
        if (enableDeepBind) {
            List<FieldAnnotation> list5 = bindAnnotationGroup.getDeepBindEntityAnnotations();
            List<FieldAnnotation> deepBindEntitiesAnnoList = bindAnnotationGroup.getDeepBindEntityListAnnotations();
            if (list5 != null || deepBindEntitiesAnnoList != null) {
                FieldAnnotation firstAnnotation;
                if (V.notEmpty(list5)) {
                    firstAnnotation = list5.get(0);
                    log.debug("\u6267\u884c\u6df1\u5ea6\u7ed1\u5b9a: {}({}) for field {}", new Object[]{firstAnnotation.getAnnotation().annotationType().getSimpleName(), firstAnnotation.getFieldClass().getSimpleName(), firstAnnotation.getFieldName()});
                }
                if (deepBindEntitiesAnnoList != null) {
                    firstAnnotation = deepBindEntitiesAnnoList.get(0);
                    log.debug("\u6267\u884c\u6df1\u5ea6\u7ed1\u5b9a: {}({}) for field {}", new Object[]{firstAnnotation.getAnnotation().annotationType().getSimpleName(), firstAnnotation.getFieldClass().getSimpleName(), firstAnnotation.getFieldName()});
                }
                DeepRelationsBinder.deepBind(voList, list5, deepBindEntitiesAnnoList);
            }
        }
    }
}

