/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.binding;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.diboot.core.binding.helper.ServiceAdaptor;
import com.diboot.core.binding.parser.ParserCache;
import com.diboot.core.binding.query.dynamic.AnnoJoiner;
import com.diboot.core.binding.query.dynamic.DynamicJoinQueryWrapper;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.mapper.DynamicQueryMapper;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Pagination;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinsBinder {
    private static final Logger log = LoggerFactory.getLogger(JoinsBinder.class);

    public static <DTO, T> T queryOne(QueryWrapper<DTO> queryWrapper, Class<T> entityClazz) {
        List<T> list = JoinsBinder.executeJoinQuery(queryWrapper, entityClazz, null, true);
        if (V.notEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <DTO, T> List<T> queryList(QueryWrapper<DTO> queryWrapper, Class<T> entityClazz) {
        return JoinsBinder.queryList(queryWrapper, entityClazz, null);
    }

    public static <DTO, T> List<T> queryList(QueryWrapper<DTO> queryWrapper, Class<T> entityClazz, Pagination pagination) {
        return JoinsBinder.executeJoinQuery(queryWrapper, entityClazz, pagination, false);
    }

    private static <DTO, T> List<T> executeJoinQuery(QueryWrapper<DTO> queryWrapper, Class<T> entityClazz, Pagination pagination, boolean limit1) {
        List mapList;
        if (!(queryWrapper instanceof DynamicJoinQueryWrapper)) {
            IService iService = ContextHolder.getIServiceByEntity(entityClazz);
            if (iService != null) {
                return ServiceAdaptor.queryList(iService, queryWrapper, pagination, entityClazz);
            }
            throw new InvalidUsageException("\u5355\u8868\u67e5\u8be2\u5bf9\u8c61\u65e0BaseService/IService\u5b9e\u73b0: " + entityClazz.getSimpleName(), new Object[0]);
        }
        long begin = System.currentTimeMillis();
        DynamicJoinQueryWrapper dynamicJoinWrapper = (DynamicJoinQueryWrapper)queryWrapper;
        dynamicJoinWrapper.setMainEntityClass(entityClazz);
        if (pagination == null) {
            if (limit1) {
                Page page = new Page(1L, 1L);
                page.setSearchCount(false);
                pageResult = JoinsBinder.getDynamicQueryMapper().queryForListWithPage(page, dynamicJoinWrapper);
                mapList = pageResult.getRecords();
            } else {
                mapList = JoinsBinder.getDynamicQueryMapper().queryForList(dynamicJoinWrapper);
            }
        } else {
            String originOrderBy = pagination.getOrderBy();
            JoinsBinder.formatOrderBy(dynamicJoinWrapper, entityClazz, pagination);
            pageResult = JoinsBinder.getDynamicQueryMapper().queryForListWithPage(pagination.toPage(entityClazz), dynamicJoinWrapper);
            pagination.setTotalCount(pageResult.getTotal());
            pagination.setOrderBy(originOrderBy);
            mapList = pageResult.getRecords();
        }
        long ms = System.currentTimeMillis() - begin;
        if (ms > 5000L) {
            log.warn("{} \u52a8\u6001Join\u67e5\u8be2\u6267\u884c\u8017\u65f6 {} ms\uff0c\u5efa\u8bae\u4f18\u5316", (Object)dynamicJoinWrapper.getDtoClass().getSimpleName(), (Object)ms);
        }
        if (V.isEmpty(mapList)) {
            return Collections.emptyList();
        }
        if (mapList.size() > BaseConfig.getBatchSize()) {
            log.warn("{} \u52a8\u6001Join\u67e5\u8be2\u8bb0\u5f55\u6570\u8fc7\u5927( {} \u6761), \u5efa\u8bae\u4f18\u5316", (Object)dynamicJoinWrapper.getDtoClass().getSimpleName(), (Object)mapList.size());
        }
        ArrayList<T> entityList = new ArrayList<T>();
        for (Map colValueMap : mapList) {
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            for (Map.Entry entry : colValueMap.entrySet()) {
                String tempFieldName;
                Field boolType;
                if (((String)entry.getKey()).endsWith("__")) {
                    log.debug("\u5ffd\u7565\u67e5\u8be2\u5360\u4f4d\u5b57\u6bb5 {}", entry.getKey());
                    continue;
                }
                String fieldName = S.toLowerCaseCamel((String)entry.getKey());
                if (entry.getValue() instanceof Boolean && S.startsWithIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"is_") && (boolType = BeanUtils.extractField(entityClazz, fieldName)) == null && (boolType = BeanUtils.extractField(entityClazz, tempFieldName = S.toLowerCaseCamel(S.substringAfter((String)((String)entry.getKey()), (String)"_")))) != null) {
                    fieldName = tempFieldName;
                }
                fieldValueMap.put(fieldName, entry.getValue());
            }
            try {
                T entityInst = entityClazz.newInstance();
                BeanUtils.bindProperties(entityInst, fieldValueMap);
                entityList.add(entityInst);
            }
            catch (Exception e) {
                log.warn("new\u5b9e\u4f8b\u5e76\u7ed1\u5b9a\u5c5e\u6027\u503c\u5f02\u5e38", (Throwable)e);
            }
        }
        return entityList;
    }

    private static <T> void formatOrderBy(DynamicJoinQueryWrapper queryWrapper, Class<T> entityClazz, Pagination pagination) {
        if (V.notEmpty(pagination.getOrderBy())) {
            String[] orderByFields;
            ArrayList<Object> orderByList = new ArrayList<Object>();
            for (String field : orderByFields = S.split(pagination.getOrderBy())) {
                List<AnnoJoiner> joinerList;
                Object fieldName = field;
                String orderType = null;
                if (field.contains(":")) {
                    String[] fieldAndOrder = S.split((String)field, (String)":");
                    fieldName = fieldAndOrder[0];
                    orderType = fieldAndOrder[1];
                }
                if ((joinerList = ParserCache.getAnnoJoiners(queryWrapper.getDtoClass(), Collections.singletonList(fieldName))).isEmpty()) {
                    fieldName = "self." + S.toSnakeCase((String)fieldName);
                    orderByList.add(V.isEmpty(orderType) ? fieldName : (String)fieldName + ":" + orderType);
                    continue;
                }
                for (AnnoJoiner annoJoiner : joinerList) {
                    fieldName = V.notEmpty(annoJoiner.getAlias()) ? annoJoiner.getAlias() + "." + annoJoiner.getColumnName() : "self." + annoJoiner.getColumnName();
                    orderByList.add(V.isEmpty(orderType) ? fieldName : (String)fieldName + ":" + orderType);
                }
            }
            pagination.setOrderBy(S.join(orderByList));
        }
    }

    private static DynamicQueryMapper getDynamicQueryMapper() {
        return ContextHolder.getBean(DynamicQueryMapper.class);
    }
}

