/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.RowStyle;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.util.TableTools;
import com.deepoove.poi.util.UnitUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public final class StyleUtils {
    public static void styleRun(XWPFRun run, Style style) {
        String vertAlign;
        int twips;
        Boolean underLine;
        Boolean strike;
        Boolean italic;
        Boolean bold;
        String highlightColor;
        String fontFamily;
        double fontSize;
        if (null == run || null == style) {
            return;
        }
        CTRPr pr = StyleUtils.getRunProperties(run);
        String color = style.getColor();
        if (StringUtils.isNotBlank((CharSequence)color)) {
            CTColor ctColor = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
            ctColor.setVal((Object)color);
            if (ctColor.isSetThemeColor()) {
                ctColor.unsetThemeColor();
            }
        }
        if (0.0 != (fontSize = style.getFontSize()) && -1.0 != fontSize) {
            BigDecimal bd = BigDecimal.valueOf(fontSize);
            CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
            ctSize.setVal(bd.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (StringUtils.isNotBlank((CharSequence)(fontFamily = style.getFontFamily()))) {
            run.setFontFamily(fontFamily);
            CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
            fonts.setAscii(fontFamily);
            fonts.setHAnsi(fontFamily);
            fonts.setCs(fontFamily);
            fonts.setEastAsia(fontFamily);
        }
        if (null != (highlightColor = style.getHighlightColor())) {
            run.setTextHighlightColor(highlightColor);
        }
        if (null != (bold = style.isBold())) {
            run.setBold(bold.booleanValue());
        }
        if (null != (italic = style.isItalic())) {
            run.setItalic(italic.booleanValue());
        }
        if (null != (strike = style.isStrike())) {
            run.setStrikeThrough(strike.booleanValue());
        }
        if (Boolean.TRUE.equals(underLine = style.isUnderLine())) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        if (0 != (twips = style.getCharacterSpacing()) && -1 != twips) {
            run.setCharacterSpacing(20 * twips);
        }
        if (StringUtils.isNotBlank((CharSequence)(vertAlign = style.getVertAlign()))) {
            run.setVerticalAlignment(vertAlign);
        }
    }

    public static void styleRun(XWPFRun dest, XWPFRun src) {
        CTRPr pr;
        BigDecimal fontSize;
        if (null == dest || null == src) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)src.getStyle())) {
            dest.setStyle(src.getStyle());
        }
        if (Boolean.TRUE.equals(src.isBold())) {
            dest.setBold(src.isBold());
        }
        if (StringUtils.isNotBlank((CharSequence)src.getColor())) {
            dest.setColor(src.getColor());
        }
        if (0 != src.getCharacterSpacing()) {
            dest.setCharacterSpacing(src.getCharacterSpacing());
        }
        if (StringUtils.isNotBlank((CharSequence)src.getFontFamily())) {
            dest.setFontFamily(src.getFontFamily());
        }
        BigDecimal bigDecimal = fontSize = (pr = src.getCTR().getRPr()) != null && pr.isSetSz() ? new BigDecimal(pr.getSz().getVal()).divide(BigDecimal.valueOf(2L)).setScale(1, RoundingMode.HALF_UP) : null;
        if (null != fontSize) {
            CTRPr destPr = StyleUtils.getRunProperties(dest);
            CTHpsMeasure ctSize = destPr.isSetSz() ? destPr.getSz() : destPr.addNewSz();
            ctSize.setVal(fontSize.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (Boolean.TRUE.equals(src.isItalic())) {
            dest.setItalic(src.isItalic());
        }
        if (Boolean.TRUE.equals(src.isStrikeThrough())) {
            dest.setStrikeThrough(src.isStrikeThrough());
        }
        if (UnderlinePatterns.NONE != src.getUnderline()) {
            dest.setUnderline(src.getUnderline());
        }
    }

    public static void styleParagraph(XWPFParagraph paragraph, ParagraphStyle style) {
        if (null == paragraph || null == style) {
            return;
        }
        StyleUtils.stylePpr(paragraph, style);
        StyleUtils.styleParaRpr(paragraph, style.getGlyphStyle());
    }

    public static void styleTable(XWPFTable table, TableStyle tableStyle) {
        if (null == table || null == tableStyle) {
            return;
        }
        String width = tableStyle.getWidth();
        StyleUtils.ensureTblW(table);
        table.setWidth(width);
        int[] colWidths = tableStyle.getColWidths();
        if (null == colWidths && table.getWidthType() == TableWidthType.DXA) {
            colWidths = UnitUtils.average(Integer.valueOf(width), TableTools.obtainColumnSize(table));
        }
        if (null != colWidths) {
            CTTblGrid tblGrid = TableTools.getTblGrid(table);
            CTTblLayoutType tblLayout = TableTools.getTblLayout(table);
            tblLayout.setType(STTblLayoutType.FIXED);
            for (int index = 0; index < colWidths.length; ++index) {
                CTTblGridCol addNewGridCol = tblGrid.addNewGridCol();
                addNewGridCol.setW(BigInteger.valueOf(colWidths[index]));
                List rows = table.getRows();
                for (XWPFTableRow row : rows) {
                    row.getCell(index).setWidth(colWidths[index] + "");
                }
            }
        }
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setLeftBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getLeftBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setRightBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getRightBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setTopBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getTopBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setBottomBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getBottomBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setInsideHBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getInsideHBorder());
        TableTools.setBorder((arg_0, arg_1, arg_2, arg_3) -> ((XWPFTable)table).setInsideVBorder(arg_0, arg_1, arg_2, arg_3), tableStyle.getInsideVBorder());
        if (null != tableStyle.getAlign()) {
            table.setTableAlignment(tableStyle.getAlign());
        }
    }

    private static void ensureTblW(XWPFTable table) {
        CTTblPr tblPr;
        CTTbl ctTbl = table.getCTTbl();
        CTTblPr cTTblPr = tblPr = ctTbl.getTblPr() != null ? ctTbl.getTblPr() : ctTbl.addNewTblPr();
        if (!tblPr.isSetTblW()) {
            tblPr.addNewTblW();
        }
    }

    public static void styleTableRow(XWPFTableRow row, RowStyle rowStyle) {
        if (null == row || null == rowStyle) {
            return;
        }
        int height = rowStyle.getHeight();
        if (0 != height) {
            row.setHeight(height);
            CTRow ctRow = row.getCtRow();
            CTTrPr properties = ctRow.isSetTrPr() ? ctRow.getTrPr() : ctRow.addNewTrPr();
            CTHeight h = properties.sizeOfTrHeightArray() == 0 ? properties.addNewTrHeight() : properties.getTrHeightArray(0);
            String heightRule = rowStyle.getHeightRule();
            if ("exact".equals(heightRule)) {
                h.setHRule(STHeightRule.EXACT);
            } else if ("atleast".equals(heightRule)) {
                h.setHRule(STHeightRule.AT_LEAST);
            } else {
                h.setHRule(STHeightRule.AUTO);
            }
        }
    }

    public static void styleTableCell(XWPFTableCell cell, CellStyle cellStyle) {
        if (null == cell || null == cellStyle) {
            return;
        }
        if (null != cellStyle.getVertAlign()) {
            cell.setVerticalAlignment(cellStyle.getVertAlign());
        }
        if (null != cellStyle.getBackgroundColor()) {
            cell.setColor(cellStyle.getBackgroundColor());
        }
    }

    private static void styleParaRpr(CTParaRPr pr, Style style) {
        if (null == pr || null == style) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)style.getColor())) {
            CTColor color = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
            color.setVal((Object)style.getColor());
        }
        if (null != style.isItalic()) {
            CTOnOff italic = pr.isSetI() ? pr.getI() : pr.addNewI();
            italic.setVal(style.isItalic() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (null != style.isBold()) {
            CTOnOff bold = pr.isSetB() ? pr.getB() : pr.addNewB();
            bold.setVal(style.isBold() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (0.0 != style.getFontSize() && -1.0 != style.getFontSize()) {
            BigDecimal bd = BigDecimal.valueOf(style.getFontSize());
            CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
            ctSize.setVal(bd.multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
        }
        if (null != style.isStrike()) {
            CTOnOff strike = pr.isSetStrike() ? pr.getStrike() : pr.addNewStrike();
            strike.setVal(style.isStrike() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (Boolean.TRUE.equals(style.isUnderLine())) {
            CTUnderline underline = pr.isSetU() ? pr.getU() : pr.addNewU();
            underline.setVal(STUnderline.SINGLE);
        }
        if (StringUtils.isNotBlank((CharSequence)style.getFontFamily())) {
            CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
            String fontFamily = style.getFontFamily();
            fonts.setAscii(fontFamily);
            if (!fonts.isSetHAnsi()) {
                fonts.setHAnsi(fontFamily);
            }
            if (!fonts.isSetCs()) {
                fonts.setCs(fontFamily);
            }
            if (!fonts.isSetEastAsia()) {
                fonts.setEastAsia(fontFamily);
            }
        }
    }

    public static void styleParaRpr(XWPFParagraph paragraph, Style style) {
        if (null == paragraph || null == style) {
            return;
        }
        CTP ctp = paragraph.getCTP();
        CTPPr pPr = ctp.isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
        CTParaRPr pr = pPr.isSetRPr() ? pPr.getRPr() : pPr.addNewRPr();
        StyleUtils.styleParaRpr(pr, style);
    }

    public static void stylePpr(XWPFParagraph paragraph, ParagraphStyle style) {
        BigInteger bi;
        CTInd indent;
        CTP ctp;
        if (null == paragraph || null == style) {
            return;
        }
        if (null != style.getAlign()) {
            paragraph.setAlignment(style.getAlign());
        }
        if (0.0 != style.getSpacing()) {
            paragraph.setSpacingBetween(style.getSpacing(), LineSpacingRule.AUTO);
        }
        CTPPr pr = (ctp = paragraph.getCTP()).isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
        CTInd cTInd = indent = pr.isSetInd() ? pr.getInd() : pr.addNewInd();
        if (0.0 != style.getIndentLeftChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentLeftChars() * 100.0)));
            indent.setLeftChars(bi);
            if (indent.isSetLeft()) {
                indent.unsetLeft();
            }
        }
        if (0.0 != style.getIndentRightChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentRightChars() * 100.0)));
            indent.setRightChars(bi);
            if (indent.isSetRight()) {
                indent.unsetRight();
            }
        }
        if (0.0 != style.getIndentHangingChars()) {
            bi = new BigInteger(String.valueOf(Math.round(style.getIndentHangingChars() * 100.0)));
            indent.setHangingChars(bi);
            if (indent.isSetHanging()) {
                indent.unsetHanging();
            }
        }
        if (-1L != style.getNumId()) {
            paragraph.setNumID(BigInteger.valueOf(style.getNumId()));
        }
        if (-1L != style.getLvl()) {
            paragraph.setNumILvl(BigInteger.valueOf(style.getLvl()));
        }
    }

    public static Style retriveStyle(XWPFRun run) {
        if (null == run) {
            return null;
        }
        Style.StyleBuilder builder = Style.builder().buildColor(run.getColor()).buildFontFamily(run.getFontFamily()).buildFontSize(run.getFontSize());
        if (run.isBold()) {
            builder.buildBold();
        }
        if (run.isItalic()) {
            builder.buildItalic();
        }
        if (run.isStrikeThrough()) {
            builder.buildStrike();
        }
        return builder.build();
    }

    private static CTRPr getRunProperties(XWPFRun run) {
        return run.getCTR().isSetRPr() ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
    }
}

